<?php

class GeneradorEtiquetaZeleris extends GeneradorEtiqueta
{
    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $configuracion = $this->cargarConfiguracion();
        $module = Module::getInstanceByName('genei');
        if(!$module || !Module::isEnabled('genei') || !$configuracion->agenciaZeleris) {
            return false;
        }
        $etiqueta = false;
        $datosSolicitud = $this->generarDatosEtiquetaZeleris($pedido, $module, $bultosManuales, $configuracion);
        if($datosSolicitud) {
           $datosSolicitud['usuario_servicio'] = $module->configurationGet('usuario_servicio_genei');
            $datosSolicitud['password_servicio'] = $module->configurationGet('password_servicio_genei');
            $datosSolicitud['cn'] = $module->cn;
            $datosSolicitud['servicio'] = Genei::SERVICIO;
            $datosSolicitud['id_usuario'] = $module->getUserId($datosSolicitud);
            
            $url = 'http://v1.genei.es/json_interface/crear_envio'; 
            $headers = array('Content-type: application/json');
            $respuesta = json_decode($this->sendCurl($url,json_encode($datosSolicitud),'post', $headers));           
            if($respuesta->resultado == 1) {
               $urlEtiquetas =
                        'http://v1.genei.es/obtener_etiqueta_envio/obtener_etiqueta_envio_servicio_externo/'
                        . $respuesta->codigo_envio
                        . '/' . $module->configurationGet('usuario_servicio_genei')
                        . '/' . $module->configurationGet('password_servicio_genei')
                        . '/prestashop';
               $etiqueta = $this->sendCurl($urlEtiquetas, '', 'get');             
            }
        }
        
        return $etiqueta;
    }
    
    /**
     * Genera la etiqueta de Zeleris.
     * @param Order $order
     * @param Module $module
     * @param BultosManuales $bultosManuales
     * @param ConfiguracionEtiqueta $configuracion
     * @return array
     */
    private function generarDatosEtiquetaZeleris($order, $module, $bultosManuales, $configuracion) {
        $datos = [];
        if($configuracion->bultosManuales) {
            $bultos = $bultosManuales->obtenerBultosManuales();
        }else {
            $bultos = $module->configurationGet('num_bultos_defecto_genei');
        }

        $alto = $module->configurationGet('alto_defecto_genei');
        $ancho = $module->configurationGet('ancho_defecto_genei');
        $largo = $module->configurationGet('largo_defecto_genei');
        $peso = $module->configurationGet('peso_defecto_genei');
        $address_delivery= new AddressCore($order->id_address_delivery);
        $customer = new Customer($order->id_customer);
        $dni = '';
        if (trim($address_delivery->vat_number) != '') {
            $dni = trim($address_delivery->vat_number);
        } else {
            $dni = trim($address_delivery->dni);
        }
        
        if (trim($address_delivery->company)!= '' && Tools::substr(trim($address_delivery->company), 0, 1)!= '-') {
            $nombreLlegada = $address_delivery->company;
        } else {
            $nombreLlegada = $address_delivery->firstname . ' ' . $address_delivery->lastname;
        }
        
        $country = new Country($address_delivery->id_country);
        $datosSalida =Tools::jsonDecode($module->configurationGet('direccion_predeterminada_genei_json'));
        if ($datosSalida == null) {
            return false;
        }
        
        for($i=0; $i<$bultos; $i++) {
            $datosBultos = [];
            $datosBultos['peso'] = $peso;
            $datosBultos['largo'] = $largo;           
            $datosBultos['ancho'] = $ancho;
            $datosBultos['alto'] = $alto;
            $datosBultos['contenido'] = '';
            $datosBultos['taric'] = '';
            $datosBultos['dni_contenido'] =  $dni;
            $datosBultos['valor'] = '';           
            $datos['array_bultos'][] = $datosBultos;
        }
        $datos['valor_mercancia'] = 0;
        $datos['contenido_envio'] = ', , ';
        $datos['contrareembolso'] = "0";
        $datos['cantidad_reembolso'] = "0";
        $datos['seguro'] = "0";
        $datos['cantidad_seguro'] = "0";
        $datos['dropshipping'] = 0;
        $datos['codigos_origen'] = $datosSalida->codigo_postal;
        $datos['poblacion_salida'] = $datosSalida->poblacion;
        $datos['iso_pais_salida'] = $datosSalida->country_code;
        $datos['direccion_salida'] = $datosSalida->direccion;
        $datos['email_salida'] = $datosSalida->mail ? $datosSalida->mail : 'email_no_informado@genei.es';
        $datos['nombre_salida'] = $datosSalida->nombre;
        $datos['telefono_salida'] = $datosSalida->telefono;
        $datos['codigos_destino'] = $module->validarFormatoCp($address_delivery->postcode, $country->iso_code);
        $datos['poblacion_llegada'] = $address_delivery->city;
        $datos['iso_pais_llegada'] = $country->iso_code;
        $datos['direccion_llegada'] = $address_delivery->address1 . " " . $address_delivery->address2;
        $datos['telefono_llegada'] = (trim($address_delivery->phone) != '' ? $address_delivery->phone : $address_delivery->phone_mobile);
        $datos['email_llegada'] = $customer->email;
        $datos['nombre_llegada'] = $nombreLlegada;
        $datos['dni_llegada'] = $dni;
        $datos['observaciones_salida'] = '';
        $datos['contacto_salida'] = '';
        $datos['observaciones_llegada'] = '-';
        $datos['contacto_llegada'] = '';
        $datos['codigo_mercancia'] = "0";
        $datos['recoger_tienda'] = "0";
        $datos['cod_promo'] = '';
        $datos['activar_oficina_destino_correos_express'] = "";
        $datos['fecha_recogida'] = date('d/m/Y', strtotime("+1 day"));
        $datos['hora_recogida_desde'] = "09:00";
        $datos['hora_recogida_hasta'] = "13:00";
        $datos['codigo_envio_servicio'] = $order->reference;
        $datos['id_agencia'] = $configuracion->agenciaZeleris;
        $datos['suplemento_picking_total'] = 0;
        $datos['suplemento_picking_total_con_iva'] = 0;
        $datos['envio_desde_almacen'] = 0;
        $datos['eori_exportacion'] = NULL;
        $datos['eori_importacion'] = NULL;
        $datos['agencias_buscar'] = '[]';
        
        return $datos;
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        $agenciasZeleris = json_decode(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'AGENCIAS_ZELERIS'));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        $formInterno->createFormCheckboxGroup($prefijo.'[bultosManuales]', $this->modulo->l('Numero de bultos manual'), 
                $configuracion->bultosManuales);
        $formInterno->createFormSelect($prefijo.'[agenciaZeleris]', $this->modulo->l('Seleccione la agencia por defecto'), $agenciasZeleris, 
                $configuracion->agenciaZeleris);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }

    public function obtenerId() {
        return 'zeleris';
    }
}
