<?php
/*
 * Crea la etiqueta de UPS.
 */
class GeneradorEtiquetaUps extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        try {
            $datosTemp = false;
            if (Module::isInstalled('upsmodule')) {
                $url = 'http://' . ImaxImprimePedidosServidor::getDomain() . '/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=generarEtiquetaUPS&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS');
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('id_order' => $pedido->id)));
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
                curl_setopt($ch, CURLOPT_TIMEOUT, 360);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                $datosTemp = curl_exec($ch);
                $infoCurl = curl_getinfo($ch);

                $numIntentos = 0;
                while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                    curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                    $datosTemp = curl_exec($ch);
                    $infoCurl = curl_getinfo($ch);

                    $numIntentos++;
                }

                curl_close($ch);
                
            }

            if ($datosTemp) {
                return $datosTemp;
            }
        } catch (Exception $ex) {
            
        }

        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'ups';
    }
    
    /**
     * Genera la etiqueta. Hecho para usar con llamada externa.
     * @param int $id_order
     */
    public function generarEtiquetaRemoto($id_order) {
        $ups = Module::getInstanceByName('upsmodule');
        Context::getContext()->employee = new Employee();
        
        //Buscamos si ya está creada la etiqueta
        $sql = new DbQuery();
        $sql->select('tracking_number');
        $sql->from('ups_shipment');
        $sql->where("id_order = '" . pSQL($id_order) . "'");
        $sql->orderBy('id desc');
        $tracking_number = Db::getInstance()->getValue($sql);
        if($tracking_number) {
            //Está creada
            $args = array();
            $args['sdk'] = UpsModule::$globalSdk;
            $args['trackingNumber'] = $tracking_number;
            $args['labelFormat'] = 'PDF';
            if($ups->downloadlabel($args)) {
                //No funciona la descarga, creamos y descargamos la etiqueta de nuevo
                $_GET['ups_label'] = true;
                $_GET['ups_services'] = 0;
                $_GET['ups_print_label'] = false;
                $_GET['ups_label_format'] = 'PDF';
                $ups->CreateUPSLabel(['id_order' => $id_order]);
                $tracking_number = Db::getInstance()->getValue($sql);
                if($tracking_number) {
                    $args['trackingNumber'] = $tracking_number;
                    $ups->downloadlabel($args);
                }
            }
        }
        else {
            //Creamos y descargamos la etiqueta
            $_GET['ups_label'] = true;
            $_GET['ups_services'] = 0;
            $_GET['ups_print_label'] = true;
            $_GET['ups_label_format'] = 'PDF';
            $ups->CreateUPSLabel(['id_order' => $id_order]);
        }
        exit;
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
