<?php
/*
 * Crea la etiqueta de Tipsa.
 */
class GeneradorEtiquetaTipsa extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        if (!is_file(dirname(__FILE__) . '/../../../tipsacarrier/pdf/etiqueta_' . $pedido->id . '.pdf')) {
            $modulo = Module::getInstanceByName('tipsacarrier');
            if ($modulo) {
                chdir(dirname(__FILE__) . '/../../../');
                
                //Bultos
                $configuracion = $this->cargarConfiguracion();
                if($configuracion->bultosManuales) {
                    $bultos = $bultosManuales->obtenerBultosManuales();
                    if($bultos) {
                        Db::getInstance()->execute('UPDATE `' . _DB_PREFIX_ . "tipsa_envios` SET bultos = $bultos WHERE id_envio_order = $pedido->id");
                    }
                }
                $idEnvio = Db::getInstance()->getValue('SELECT id_envio FROM `' . _DB_PREFIX_ . "tipsa_envios` WHERE id_envio_order = '$pedido->id'");
                $modulo->printLabel($idEnvio);
            }
        }

        $datos = false;
        if (is_file(dirname(__FILE__) . '/../../../tipsacarrier/pdf/etiqueta_' . $pedido->id . '.pdf')) {
            $datos = file_get_contents(dirname(__FILE__) . '/../../../tipsacarrier/pdf/etiqueta_' . $pedido->id . '.pdf');
        }

        return $datos;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'tipsa';
    }
    
    /**
     * {@inheritDoc}
     */
    public function obtenerBultosBloqueados($pedido) {
        return is_file(dirname(__FILE__) . '/../../../tipsacarrier/pdf/etiqueta_' . $pedido->id . '.pdf');
    }
}
