<?php
/*
 * Crea la etiqueta de Seur.
 */
class GeneradorEtiquetaSeur extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        require_once(_PS_MODULE_DIR_ . DIRECTORY_SEPARATOR . 'seur' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'SeurOrder.php');
        require_once(_PS_MODULE_DIR_ . DIRECTORY_SEPARATOR . 'seur' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Pickup.php');
        require_once(_PS_MODULE_DIR_ . DIRECTORY_SEPARATOR . 'seur' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'SeurLib.php');
        require_once(_PS_MODULE_DIR_ . DIRECTORY_SEPARATOR . 'seur' . DIRECTORY_SEPARATOR . 'controllers' . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . 'AdminSeurShippingController.php');

        //Tipo de impresion configurado
        $impresionesSeleccionadas = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'IMPRESIONES'));
        $idLocal = $this->modulo->obtenerLocalPedido($pedido);
        $defaultType = Configuration::get('SEUR2_SETTINGS_PRINT_TYPE');
        $labelName = Configuration::get('SEUR2_SETTINGS_LABEL_REFERENCE_TYPE');
        $numericType = (!empty($impresionesSeleccionadas[$idLocal]) ? $impresionesSeleccionadas[$idLocal] : $defaultType);
        $type = ($numericType == 1 ? 'pdf' : 'txt');
        Configuration::set('SEUR2_SETTINGS_PRINT_TYPE', $numericType);

        $name = ($labelName == 1 || !$labelName ? $pedido->reference : $pedido->id);
        $directory = _PS_MODULE_DIR_.'seur/files/deliveries_labels/';
        if (($type == 'txt' && !is_file($directory.$name.'.txt')) || ($type == 'pdf' && !is_file($directory.$name.'.pdf'))) {
            //Para evitar errores
            $this->context->employee->id = 0;
            define('_PS_BO_ALL_THEMES_DIR_', '');
            define('_PS_ADMIN_DIR_', '');
            
            $seur_order = SeurOrder::getByOrder($pedido->id);
            if($seur_order) {
                //Cambiamos el ccc
                $cccs = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'CCC_LOCAL'));
                if(!empty($cccs[$idLocal]) && $seur_order->id_seur_ccc != $cccs[$idLocal]) {
                    $seur_order->id_seur_ccc = $cccs[$idLocal];
                    $seur_order->save();
                }
                
                $controller = new AdminSeurShippingController();
                $controller->createLabel($seur_order->id);
            }
        }

        $datos = false;
        if ($type == 'txt') {
            if (is_file($directory.$name.'.txt')) {
                $datos = Tools::file_get_contents($directory.$name.'.txt');
            }
        }
        elseif ($type == 'pdf') {
            if (is_file($directory.$name.'.pdf')) {
                 $datos = Tools::file_get_contents($directory.$name.'.pdf');
            }
        }

        if ($datos) {
            //Creamos una recogida
            $cccs = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'CCC_LOCAL'));
            $idLocal = $this->modulo->obtenerLocalPedido($pedido);
            if(!empty($cccs[$idLocal])) {
                $ultimaRecogida = SeurPickup::getLastPickup($cccs[$idLocal]);
                if (!empty($ultimaRecogida)) {
                    $fechaUltimaRecogida = explode(' ', $ultimaRecogida['date']);
                }
                
                if (empty($ultimaRecogida) || strtotime(date('Y-m-d')) != strtotime($fechaUltimaRecogida[0])) {
                    SeurPickup::createPickup($cccs[$idLocal]);
                }
            }
        }

        return $datos;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'seur';
    }
    
    /**
     * {@inheritDoc}
     */
    public function grabarConfiguracion($post) {
        $cccLocal = Tools::getValue('cccLocal', array());
        Configuration::updateGlobalValue(ImaxImprimePedidosServidor::prefijo . 'CCC_LOCAL', serialize($cccLocal));
        $impresiones = Tools::getValue('impresiones', array());
        Configuration::updateGlobalValue(ImaxImprimePedidosServidor::prefijo . 'IMPRESIONES', serialize($impresiones));
        return parent::grabarConfiguracion($post);
    }

    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        if(Module::isEnabled('seur')) {
            $formInterno->addToForm('<p><strong>'.$this->modulo->l('Generacion de recogida por local:').'</strong></p>'.$this->generarTablaLocalesSeur());
        }
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
    
    /**
     * Crea una tabla con los locales y cccs de Seur.
     * @return string
     */
    private function generarTablaLocalesSeur() {
        $tabla = '<table class="table"><thead><tr><th>'.$this->modulo->l('Local').'</th><th>'.$this->modulo->l('CCC').'</th><th>'.$this->modulo->l('Impresion').'</th></tr></thead><tbody>';
        
        if(is_file(_PS_MODULE_DIR_.'seur/classes/SeurCCC.php')) {
            require_once _PS_MODULE_DIR_.'seur/classes/SeurCCC.php';
            
            $cccsSeleccionados = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'CCC_LOCAL'));
            $impresionesSeleccionadas = unserialize(Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo.'IMPRESIONES'));
            $locales = $this->modulo->obtenerLocales();
            if(method_exists('SeurCCC', 'getCCCs')) {
                $cccs = SeurCCC::getCCCs();
            }
            elseif(method_exists('SeurCCC', 'getListCCC')) {
                $cccs = SeurCCC::getListCCC();
            }
            else {
                $cccs = [];
            }
            foreach($locales as $local) {
                $pdfSeleccionado = (isset($impresionesSeleccionadas[$local['id_store']]) && $impresionesSeleccionadas[$local['id_store']] == 1 ? 'selected="selected"' : '');
                $textoSeleccionado = (isset($impresionesSeleccionadas[$local['id_store']]) && $impresionesSeleccionadas[$local['id_store']] == 2 ? 'selected="selected"' : '');
                $nadaSeleccionado = (!$pdfSeleccionado && !$textoSeleccionado ? 'selected="selected"' : '');
                
                $select = $this->generarSelectCCCs("cccLocal[{$local['id_store']}]", $cccs, (isset($cccsSeleccionados[$local['id_store']]) ? $cccsSeleccionados[$local['id_store']] : 0));
                $tabla .= "
                    <tr>
                        <td>{$local['name']}</td>
                        <td>$select</td>
                        <td>
                            <select name='impresiones[{$local['id_store']}]'>
                                <option value='0' $nadaSeleccionado>".$this->modulo->l('- Valor del modulo de Seur -')."</option>
                                <option value='1' $pdfSeleccionado>".$this->modulo->l('PDF')."</option>
                                <option value='2' $textoSeleccionado>".$this->modulo->l('Texto')."</option>
                            </select>
                        </td>
                    </tr>";
            }
        }
        $tabla .= '</tbody></table>';
        
        return $tabla;
    }
    
    /**
     * Crea un select de ccc de Seur.
     * @param string $nombre
     * @param array $cccs
     * @param int $cccSeleccionado
     */
    private function generarSelectCCCs($nombre, $cccs, $cccSeleccionado = 0) {
        $ninguno = $this->modulo->l('- No generar recogida -');
        $selected = (!$cccSeleccionado ? 'selected="selected"' : '');
        $select = "<select name='$nombre'><option value='0' $selected>$ninguno</option>";
        foreach($cccs as $ccc) {
            $selected = ($cccSeleccionado == $ccc['id_seur_ccc'] ? 'selected="selected"' : '');
            $nombre = (isset($ccc['nombre_personalizado']) ? $ccc['nombre_personalizado'] : $ccc['street_name'].', '.$ccc['town']);
            $select .= "<option value='{$ccc['id_seur_ccc']}' $selected>$nombre</option>";
        }
        $select .= '</select>';
        
        return $select;
    }
}
