<?php
/*
 * Crea la etiqueta de MRW.
 */
class GeneradorEtiquetaMrw extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        try {
            $temp = Db::getInstance()->getRow('SELECT send_num_mrw, order_id, id_shop  FROM `' . _DB_PREFIX_ . 'mrwcarrier_mrw` where order_id = ' . $pedido->id);
            if ($temp) {
                $nombreArchivo = $temp['send_num_mrw'];
            } else {
                $nombreArchivo = '';
            }
            if (!$nombreArchivo || !is_file(dirname(__FILE__) . '/../../../../download/ticket_mrw/' . $nombreArchivo . '.pdf')) {
                if ($pedido->getCurrentState() != Configuration::get('MRWCARRIER_BEFORE_SENDING_MRW')) {
                    $pedido->setCurrentState(Configuration::get('MRWCARRIER_BEFORE_SENDING_MRW'),
                            (Validate::isLoadedObject($this->context->employee) ? $this->context->employee->id : 0));
                }

                if (Module::isInstalled('mrwcarrier')) {
                    $mrw = Module::getInstanceByName('mrwcarrier');
                                        
                    //Numero de bultos
                    $bultos = $this->modulo->obtenerBultos($pedido->id);
                    if($bultos > 1) {
                        $_POST['regNewLump'] = 1;
                        $_POST['newLump'] = $bultos;
                        $mrw->hookAdminOrder(array('id_order' => $pedido->id));
                    }

                    $mrw->executeSendMRW($pedido->id);
                    $temp = Db::getInstance()->getRow('SELECT send_num_mrw, order_id, id_shop FROM `' . _DB_PREFIX_ . 'mrwcarrier_mrw` where order_id = ' . $pedido->id);
                    $nombreArchivo = $temp['send_num_mrw'];
                    
                    if(method_exists($mrw, 'getPDF64National')) {
                        $etiqueta = MrwCarrier::getPDF64National($nombreArchivo);
                        if($etiqueta) {
                            file_put_contents(dirname(__FILE__) . '/../../../../download/ticket_mrw/' . $nombreArchivo . '.pdf', $etiqueta);
                        }
                    }
                    else {
                        $mrw->getEtiquetaEnvio($nombreArchivo, $temp['order_id'], $temp['id_shop']);
                    }
                }
            }

            if (is_file(dirname(__FILE__) . '/../../../../download/ticket_mrw/' . $nombreArchivo . '.pdf')) {
                return file_get_contents(dirname(__FILE__) . '/../../../../download/ticket_mrw/' . $nombreArchivo . '.pdf');
            }
        } catch (Exception $ex) {
            
        }

        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'mrw';
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
