<?php
/*
 * Crea la etiqueta de Mondial Relay.
 */
class GeneradorEtiquetaMondialRelay extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $datos = false;

        if (!is_file(_PS_MODULE_DIR_.'imaxmondialrelay/labels/'.$pedido->id.'.pdf')) {
            $relay = Module::getInstanceByName('imaxmondialrelay');
            $this->errorEtiqueta = $relay->getFunciones()->generarEtiqueta($pedido);
		}

        if (is_file(_PS_MODULE_DIR_.'imaxmondialrelay/labels/'.$pedido->id.'.pdf')) {
            $datos = file_get_contents(_PS_MODULE_DIR_.'imaxmondialrelay/labels/'.$pedido->id.'.pdf');
        }

        return $datos;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'modial_relay';
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
