<?php
/*
 * Crea la etiqueta de GLS.
 */
class GeneradorEtiquetaGls extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        try {
            if (Module::isInstalled('glsshipping')) {
                if (!is_file(dirname(__FILE__) . '/../../../glsshipping/PDF/etiqueta_' . $pedido->id . '.pdf')) {
                    chdir(dirname(__FILE__).'/../../..');
                    $_POST['regenerar'] = 1;
                    $_POST['id_order'] = $pedido->id;
                    $configuracion = $this->cargarConfiguracion();
                    if($configuracion->etiqXprodGls) {
                        $usarProductPackage = $configuracion->usarProductPackageGls;
                        $productPackagePresente = Module::isEnabled('trzproductpackage');

                        $detalles = $pedido->getProductsDetail();
                        $bultos = 0;
                        foreach ($detalles AS $detalle) {
                            if($productPackagePresente && $usarProductPackage) {
                                $multiplo = $this->obtenerPaquetesTRZ($detalle['product_id']);
                            }
                            else {
                                $multiplo = 1;
                            }

                            $bultos += $detalle['product_quantity'] * $multiplo;
                        }

                        $_POST['gls_bultos_user'] = $bultos;
                    }
                    elseif($configuracion->bultosManuales) {
                        $bultos = $bultosManuales->obtenerBultosManuales();
                        if($bultos) {
                            $_POST['gls_bultos_user'] = $bultos;
                        }
                    }

                    if($configuracion->incluirRefsGls) {
                        $_POST['gls_observaciones_user'] = $this->generarReferenciasString($pedido);
                    }

                    try {
                        $gls = Module::getInstanceByName('glsshipping');
                        $gls->hookAdminOrder(array());
                    }
                    catch(Exception $ex) { }
                    
                    //Los de gls meten el tracking en base de datos, emulamos el hook para el imaxmultiseguimiento
                    if(Module::isEnabled('imaxmultiseguimiento')) {
                        $seguimiento = Db::getInstance()->getRow('SELECT codigo_envio, num_albaran FROM `'._DB_PREFIX_."gls_envios` WHERE id_envio_order = $pedido->id");
                        if($seguimiento) {
                            $pedidoCarrier = new OrderCarrier();
                            $pedidoCarrier->id_carrier = $pedido->id_carrier;
                            $pedidoCarrier->id_order = $pedido->id;
                            $pedidoCarrier->tracking_number = ($seguimiento['num_albaran'] ? $seguimiento['num_albaran'] : $seguimiento['codigo_envio']);

                            $multi = Module::getInstanceByName('imaxmultiseguimiento');
                            $multi->hookActionObjectOrderCarrierAddBefore(array('object' => $pedidoCarrier));
                        }
                    }
                }

                if (is_file(dirname(__FILE__) . '/../../../glsshipping/PDF/etiqueta_' . $pedido->id . '.pdf')) {
                    return file_get_contents(dirname(__FILE__) . '/../../../glsshipping/PDF/etiqueta_' . $pedido->id . '.pdf');
                }
            }
        }
        catch (Exception $ex) { }

        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'gls';
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l('Selecciona los transportistas de GLS:'), 
                $this->modulo->l('Selecciona los transportistas de GLS:'), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l('Estado de los pedidos de GLS despues de generar la etiqueta:'), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        $formInterno->createFormCheckboxGroup($prefijo.'[incluirRefsGls]', $this->modulo->l('Incluir referencias de productos en el pedido si es Gls'), 
                $configuracion->incluirRefsGls);
        $formInterno->createFormCheckboxGroup($prefijo.'[etiqXprodGls]', $this->modulo->l('Imprimir una etiqueta por cada producto de GLS'), 
                $configuracion->etiqXprodGls);
        $formInterno->createFormCheckboxGroup($prefijo.'[bultosManuales]', $this->modulo->l('Numero de bultos manual'), 
                $configuracion->bultosManuales);
        if(Module::isEnabled('trzproductpackage')) {
            $formInterno->createFormCheckboxGroup($prefijo.'[usarProductPackageGls]', 
                    $this->modulo->l('Cantidad de etiquetas segun modulo Product Package (incluye la opcion anterior).'), 
                    $configuracion->usarProductPackageGls);
        }

        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
    
    /**
     * {@inheritDoc}
     */
    public function grabarConfiguracion($post) {
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        if(Tools::getValue($prefijo.'[usarProductPackageGls]')) {
            $_POST[$prefijo.'[etiqXprodGls]'] = true;
        }

        return parent::grabarConfiguracion($post);
    }
    
    /**
     * {@inheritDoc}
     */
    public function obtenerBultosBloqueados($pedido) {
        return is_file(dirname(__FILE__) . '/../../../glsshipping/PDF/etiqueta_' . $pedido->id . '.pdf');
    }
}
