<?php
/*
 * Crea la etiqueta de GDS.
 */
class GeneradorEtiquetaGds extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $pass = Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS');
        $ch = curl_init('https://' .ImaxImprimePedidosServidor::getDomain() . "/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?passRemota=$pass&accion=obtenerEtiquetaGDS&id_order=$pedido->id");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);

        $numIntentos = 0;
        while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
            curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
            $datos = curl_exec($ch);
            $infoCurl = curl_getinfo($ch);

            $numIntentos++;
        }

        curl_close($ch);

        return $datos;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'gds';
    }
    
    /**
     * Genera la etiqueta. Hecho para usar con llamada externa.
     * @param int $id_order
     */
    public function generarEtiquetaRemoto($id_order) {
        require_once(_PS_MODULE_DIR_ . 'springxbs/controllers/admin/AdminSpringxbsApiController.php');
		
		Context::getContext()->employee = new Employee();
        
        $controlador = new AdminSpringxbsApiController();
        $shipment = AdminSpringxbsApiController::getShipmentStatic($id_order);
        if($shipment) {
            $controlador->ajaxProcessPrintLabel();
        }
        else {
            $controlador->ajaxProcessCreateLabel();
        }
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
