<?php
/*
 * Crea la etiqueta de Fedex.
 */
class GeneradorEtiquetaFedex extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        try {
            if (Module::isInstalled('fedexdotcom')) {
                $etiquetaFedex = glob(_PS_MODULE_DIR_ . "fedexdotcom/labels/$pedido->id/*.pdf");
                if (!$etiquetaFedex || !is_file($etiquetaFedex[0])) {
                    $sql = 'SELECT id_employee FROM `' . _DB_PREFIX_ . 'employee` WHERE id_profile = 1 AND active = 1';
                    $idEmployee = Db::getInstance()->getValue($sql);
                    $url = 'http://' .ImaxImprimePedidosServidor::getDomain() . '/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=generarEtiquetaFedex&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS');
                    $ch = curl_init($url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('id_order' => $pedido->id, 'id_employee' => $idEmployee, 
                        'action' => 'generate_shipping_label')));
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 360);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                    $datosTemp = curl_exec($ch);
                    $infoCurl = curl_getinfo($ch);

                    $numIntentos = 0;
                    while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                        curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                        $datosTemp = curl_exec($ch);
                        $infoCurl = curl_getinfo($ch);

                        $numIntentos++;
                    }

                    curl_close($ch);
                }

                $etiquetaFedex = glob(_PS_MODULE_DIR_ . "fedexdotcom/labels/$pedido->id/*.pdf");
                if ($etiquetaFedex && is_file($etiquetaFedex[0])) {
                    return file_get_contents($etiquetaFedex[0]);
                }
                elseif(!empty($datosTemp)) {
                    $mensaje = json_decode($datosTemp);
                    if($mensaje) {
                        $this->errorEtiqueta = trim(strip_tags($mensaje->html));
                    }
                }
            }
        }
        catch (Exception $ex) { }

        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'fedex';
    }
    
    /**
     * Genera la etiqueta. Hecho para usar con llamada externa.
     * @param int $idEmployee
     */
    public function generarEtiquetaRemoto($idEmployee) {
        require_once _PS_MODULE_DIR_ . "fedexdotcom/FedExDotComAjaxFunctions.php";
        
        $psAdminDir = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ADMIN');
        if(!defined('_PS_ADMIN_DIR_')) {
            define('_PS_ADMIN_DIR_', $psAdminDir);
            define('_PS_BO_ALL_THEMES_DIR_', _PS_ADMIN_DIR_.'/themes/');
        }

        Context::getContext()->employee = new Employee($idEmployee);
        Cache::store('isLoggedBack' . $idEmployee, true);

        $controlador = new FedExDotComAjaxFunctions();
        $controlador->postProcess();
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
