<?php
/*
 * Crea la etiqueta de Envialia.
 */
class GeneradorEtiquetaEnvialia extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        if (Configuration::get('ENVIALIA_ESTADO_PEDIDO') && $pedido->getCurrentState() != Configuration::get('ENVIALIA_ESTADO_PEDIDO')) {
            $pedido->setCurrentState(Configuration::get('ENVIALIA_ESTADO_PEDIDO'),
                    (Validate::isLoadedObject($this->context->employee) ? $this->context->employee->id : 0));
        }
        
        if(is_file(dirname(__FILE__) . '/../../../envialiacarrier/controllers/admin/AdminEnvialiaEnvioController.php')) {
            //Version 1 del modulo
            $tienda = new Shop($this->modulo->idShop);
            $url = $tienda->getBaseURL();
            $datos = $this->sendCurl($url . 'modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=generarEtiquetaEnvialia&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS'), 
                    array('action' => 'impEtiq', 'id_order' => $pedido->id));
        }
        else {
            //Otra version
            $nombreArchivo = "etiqueta_" . $pedido->id;
            if (!is_file(dirname(__FILE__) . '/../../../envialiacarrier/PDF/' . $nombreArchivo . '.pdf')) {
                if (!class_exists('AdminEnvialiaCarrierController', false)) {
                    require_once dirname(__FILE__) . '/../../../envialiacarrier/controllers/admin/AdminEnvialiaCarrierController.php';
                }
                require_once dirname(__FILE__) . '/../AdminEnvialiaCarrierControllerOverride.php';

                $controlador = new AdminEnvialiaCarrierControllerOverride();
                $controlador->idPedido = $pedido->id;
                $controlador->processBulkImprimirSeleccionados();
            }
            
            $datos = false;
            if (is_file(dirname(__FILE__) . '/../../../envialiacarrier/PDF/' . $nombreArchivo . '.pdf')) {
                $datos = file_get_contents(dirname(__FILE__) . '/../../../envialiacarrier/PDF/' . $nombreArchivo . '.pdf');
            }
        }

        return $datos;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'envialia';
    }
    
    /**
     * Genera la etiqueta. Hecho para usar con llamada externa.
     */
    public function generarEtiquetaRemoto() {
        $psAdminDir = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ADMIN');
        if(!defined('_PS_ADMIN_DIR_')) {
            define('_PS_ADMIN_DIR_', $psAdminDir);
            define('_PS_BO_ALL_THEMES_DIR_', _PS_ADMIN_DIR_.'/themes/');
        }
    
    
        require_once dirname(__FILE__) . '/../../../envialiacarrier/controllers/admin/AdminEnvialiaEnvioController.php';
        
        $sql = 'SELECT id_employee FROM ' . _DB_PREFIX_ . 'employee WHERE id_profile=1 AND active=1';
        $idEmployee = Db::getInstance()->getValue($sql);
        Context::getContext()->employee = new Employee($idEmployee);
		Cache::store('isLoggedBack' . $idEmployee, true);

        $controlador = new AdminEnvialiaEnvioController();
        $controlador->postProcess();
        exit; 
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
