<?php
/*
 * Crea la etiqueta de DHL.
 */
class GeneradorEtiquetaDhl extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $imaxdhl = Module::getInstanceByName('imaxdhl');
        $imaxdhlcarrier = Module::getInstanceByName('imaxdhlcarrier');
        $imaxdhlparcel = Module::getInstanceByName('imaxdhlparcelv3');
        if(Module::isEnabled('imaxdhlparcelv3') && $imaxdhlparcel->getFunciones()->esDhl($pedido)) {
            //Modulo de DHL parcel de Informax
            if (!is_file(dirname(__FILE__) . '/../../../imaxdhlparcelv3/pdf/' . $pedido->id . '.pdf')) {
                $telefonoFalso = $this->obtenerTelefonoFalso($pedido);
                $imaxdhlparcel->hookActionOrderStatusPostUpdate(array('id_order' => $pedido->id), true, $telefonoFalso);
            }

            $datos = false;
            if (is_file(dirname(__FILE__) . '/../../../imaxdhlparcelv3/pdf/' . $pedido->id . '.pdf')) {
                $datos = file_get_contents(dirname(__FILE__) . '/../../../imaxdhlparcelv3/pdf/' . $pedido->id . '.pdf');
            }
        }
        if(Module::isEnabled('imaxdhl') && $imaxdhl->getFunciones()->esDhl($pedido)) {
            //Modulo de DHL Express de Informax
            $ficheros = $imaxdhl->getFunciones()->cargarEtiquetas($pedido, false);
            if (!$ficheros) {
                $_POST['contenido'] = $this->obtenerContenidoDhlAir($pedido);
                $imaxdhl->hookActionOrderStatusPostUpdate(array('id_order' => $pedido->id), true);
            }
            
            $datos = false;
            $ficheros = $imaxdhl->getFunciones()->cargarEtiquetas($pedido, false);
            if ($ficheros) {
                $ruta = $ficheros[max(array_keys($ficheros))];
                $datos = file_get_contents($ruta);
            }
        }
        elseif(Module::isEnabled('imaxdhlcarrier') && $imaxdhlcarrier->getFunciones()->esDhl($pedido)) {
            //Modulo de DHL de Informax
            if (!is_file(dirname(__FILE__) . '/../../../imaxdhlcarrier/pdf/' . $pedido->id . '.pdf')) {
                $imaxdhlcarrier->hookActionOrderStatusPostUpdate(array('id_order' => $pedido->id), true);
            }

            $datos = false;
            if (is_file(dirname(__FILE__) . '/../../../imaxdhlcarrier/pdf/' . $pedido->id . '.pdf')) {
                $datos = file_get_contents(dirname(__FILE__) . '/../../../imaxdhlcarrier/pdf/' . $pedido->id . '.pdf');
            }
        }
        elseif(Module::isEnabled('esp_dhl')) {
            //Modulo de DHL de Soy.es
            $expedicion = Db::getInstance()->getValue('SELECT COEXPE FROM `'._DB_PREFIX_."esp_dhl_tracking` WHERE id_pedido = '$pedido->id'");
            if (!$expedicion || !is_file(dirname(__FILE__) . '/../../../esp_dhl/files_generated/pdf/etiqueta_' . $expedicion . '.pdf')) {
                $modulo = Module::getInstanceByName('esp_dhl');
                if($modulo) {
                    $_POST['DHL_envio_individual'] = 1;
                    $_POST['id_rel_cuentas_servicio'] = 1;
                    $_POST['dhl_bultos'] = 1;
                    $_POST['dhl_observaciones'] = '';
                    $modulo->hookAdminOrder(array('id_order' => $pedido->id));
                }
            }
            
            $datos = false;
            $expedicion = Db::getInstance()->getValue('SELECT COEXPE FROM `'._DB_PREFIX_."esp_dhl_tracking` WHERE id_pedido = '$pedido->id'");
            if ($expedicion && is_file(dirname(__FILE__) . '/../../../esp_dhl/files_generated/pdf/etiqueta_' . $expedicion . '.pdf')) {
                $datos = file_get_contents(dirname(__FILE__) . '/../../../esp_dhl/files_generated/pdf/etiqueta_' . $expedicion . '.pdf');
            }
        }
        elseif(Module::isEnabled('esp_dhl_air')) {
            //Modulo de DHL AIR de Soy.es
            $expedicion = Db::getInstance()->getValue('SELECT shipment_identification_number FROM `'._DB_PREFIX_."esp_dhl_air_envio` WHERE id_order = '$pedido->id' ORDER BY id DESC");
            if (!$expedicion || !is_file(dirname(__FILE__) . '/../../../esp_dhl_air/generatedLabels/' . $expedicion . '.pdf')) {
                $modulo = Module::getInstanceByName('esp_dhl_air');
                if($modulo) {
                    $contenido = $this->obtenerContenidoDhlAir($pedido);
                    $postDatos = array(array('alto' => 1, 'ancho' => 1, 'contenido' => ($contenido ? $contenido : 'Goods'), 'largo' => 1, 'peso' => 1));
                    $postOpciones = array('bultos' => 1, 'documentos' => 1, 'mercancia_peligrosa' => 0, 'relacion' => 1, 'seguro' => 0, 
                        'valor_asegurado' => $pedido->getTotalProductsWithoutTaxes(), 'valor_declarado' => $pedido->getTotalProductsWithoutTaxes());
                    
                    //Primer paso
                    $post = array();
                    $post['datos[0][alto]'] = $postDatos[0]['alto'];
                    $post['datos[0][ancho]'] = $postDatos[0]['ancho'];
                    $post['datos[0][contenido]'] = $postDatos[0]['contenido'];
                    $post['datos[0][largo]'] = $postDatos[0]['largo'];
                    $post['datos[0][peso]'] = $postDatos[0]['peso'];
                    $post['destino'] = $pedido->id_address_delivery;
                    $post['opciones[bultos]'] = $postOpciones['bultos'];
                    $post['opciones[documentos]'] = $postOpciones['documentos'];
                    $post['opciones[mercancia_peligrosa]'] = $postOpciones['mercancia_peligrosa'];
                    $post['opciones[relacion]'] = $postOpciones['relacion'];
                    $post['opciones[seguro]'] = $postOpciones['seguro'];
                    $post['opciones[valor_asegurado]'] = $postOpciones['valor_asegurado'];
                    $post['opciones[valor_declarado]'] = $postOpciones['valor_declarado'];
                    $post['pedido'] = $pedido->id;
                    $post['tienda'] = $this->modulo->idShop;
                    $post['token'] = substr(Tools::encrypt('esp_dhl_air/index'), 0, 10);

                    $ch = curl_init('https://' . ImaxImprimePedidosServidor::getDomain() . "/modules/esp_dhl_air/esp_dhl_air-ajax.php");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                    curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 360);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                    $datos = curl_exec($ch);
                    $infoCurl = curl_getinfo($ch);

                    $numIntentos = 0;
                    while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                        curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                        $datos = curl_exec($ch);
                        $infoCurl = curl_getinfo($ch);

                        $numIntentos++;
                    }

                    curl_close($ch);
                    
                    if ($infoCurl['http_code'] == 200 && $numIntentos <= 10 && $datos) {
                        //Segundo paso
                        $tipoServicio = '';
                        $tiposServicio = array();
                        $servicios = json_decode($datos, true);
                        foreach($servicios['Provider']['Service'] as $servicio) {
                            $tiposServicio[] = array('tipo' => $servicio['type'], 'nombre' => $servicio['Charges']['Charge'][0]['ChargeType'], 
                                'precio' => $servicio['TotalNet']['Amount']);
                            
                            if($servicio['type'] == 'U') {
                                $tipoServicio = 'U';
                            }
                            elseif($servicio['type'] == 'N') {
                                $tipoServicio = 'N';
                            }
                        }
                        
                        $_POST['esp_dhl_air_datos_shipment_request'] = json_encode($postDatos);
                        $_POST['esp_dhl_air_envio_individual'] = 'Generar Envío';
                        $_POST['esp_dhl_air_envio_select'] = $tipoServicio;
                        $_POST['esp_dhl_air_envios_shipment_request'] = json_encode($tiposServicio);
                        $_POST['esp_dhl_air_opciones_shipment_request'] = json_encode($postOpciones);
                        $_POST['id_relacion'] = $postOpciones['relacion'];
                        $_POST['valor_asegurado'] = $postOpciones['valor_asegurado'];
                        
                        $modulo->hookAdminOrder(array('id_order' => $pedido->id));
                    }
                }
            }
            
            $datos = false;
            $expedicion = Db::getInstance()->getValue('SELECT shipment_identification_number FROM `'._DB_PREFIX_."esp_dhl_air_envio` WHERE id_order = '$pedido->id' ORDER BY id DESC");
            if ($expedicion && is_file(dirname(__FILE__) . '/../../../esp_dhl_air/generatedLabels/' . $expedicion . '.pdf')) {
                $datos = file_get_contents(dirname(__FILE__) . '/../../../esp_dhl_air/generatedLabels/' . $expedicion . '.pdf');
            }
        }
        elseif(Module::isEnabled('dhlexpress')) {
            require_once dirname(__FILE__).'/../../../dhlexpress/classes/DhlPackage.php';
            require_once dirname(__FILE__).'/../../../dhlexpress/classes/DhlExtracharge.php';
            require_once dirname(__FILE__).'/../../../dhlexpress/classes/DhlOrder.php';
            require_once dirname(__FILE__).'/../../../dhlexpress/classes/DhlLabel.php';
            
            $datos = false;
            $dhlOrder = DhlOrder::getByIdOrder($pedido->id);
            if($dhlOrder) {
                $dhlLabel = DhlLabel::getByIdDhlOrder($dhlOrder->id);
                if($dhlLabel) {
                    $datos = base64_decode($dhlLabel->label_string);
                }
            }
            
            if(!$datos) {
                $post = $this->getDhlExpressVars($pedido);
                $tienda = new Shop($this->modulo->idShop);
                $url = $tienda->getBaseURL();
                $datosTemp = $this->sendCurl($url . 'modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=obtenerProductosDHL&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS'), $post);
                if ($datosTemp) {
                    $servicioBarato = '';
                    $precioServicio = 9999999;

                    $obj = json_decode($datosTemp);
                    $data = json_decode(preg_replace('/<!--(.|\s)*?-->\n/', '', $obj->html));
                    foreach($data[0] as $codigo => $servicios) {
                        $codigo = trim($codigo);
                        if(isset($data[1]->$codigo)) {
                            foreach($servicios as $servicio) {
                                if($servicio->ChargeWithoutTax < $precioServicio) {
                                    $precioServicio = $servicio->ChargeWithoutTax;
                                    $servicioBarato = $codigo.'_'.$servicio->LocalProductCode;
                                    $codigoBarato = $codigo;
                                }
                            }
                        }
                    }

                    $post['dhl_label_service'] = $servicioBarato;
                    $post['dhl_label_local_code_'.$servicioBarato] = $codigoBarato;

                    $datosTemp = json_decode($this->sendCurl($url . 'modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=generarEtiquetaDHL&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS'), $post));		
                    if($datosTemp && !$datosTemp->errors) {
                        $dhlOrder = DhlOrder::getByIdOrder($pedido->id);
                        if($dhlOrder) {
                            $dhlLabel = DhlLabel::getByIdDhlOrder($dhlOrder->id);
                            if($dhlLabel) {
                                $datos = base64_decode($dhlLabel->label_string);
                            }
                        }
                    }
                }
            }
        }

        return $datos;
    }
    
    /**
     * Devuelve el contenido para la aduana.
     * @param Order $pedido
     * @return String 
     */
    private function obtenerContenidoDhlAir($pedido) {
        $contenido = array();
        
        $productos = $pedido->getProducts();
        foreach($productos as $producto) {
            $id_category = (int)$producto['id_category_default'];
            $contenidoTemp = Db::getInstance()->getValue('SELECT dhlAirContenido FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."catExtra` WHERE id_category = '$id_category'");
            if($contenidoTemp) {
                $contenido[] = $contenidoTemp;
            }
        }
        
        return implode(', ', array_unique($contenido));
    }
    
    /**
     * Devuelve las variables para dhl express.
     * @param Order $order
     * @return array
     */
    private function getDhlExpressVars($order) {
        $currency = new Currency($order->id_currency);
        $defaultSenderAddrDelivery = (int) Configuration::get('DHL_DEFAULT_SENDER_ADDRESS');
        $defaultShipmentContent = Configuration::get('DHL_DEFAULT_SHIPMENT_CONTENT');
        $labelType = Configuration::get('DHL_LABEL_TYPE');
        $defaultPackageId = (int) Configuration::get('DHL_DEFAULT_PACKAGE_TYPE');
        $dhlPackage = new DhlPackage($defaultPackageId);
        if (Validate::isLoadedObject($dhlPackage)) {
            $dim = $defaultPackageId . 'x' .
                  $dhlPackage->weight_value . 'x' .
                  $dhlPackage->length_value . 'x' .
                  $dhlPackage->width_value . 'x' .
                  $dhlPackage->depth_value;
        }

        $post = array();
        $extracharges = DhlExtracharge::getExtrachargesList($this->context->language->id);
        foreach ($extracharges as $extracharge) {
            $idDhlExtracharge = (int) $extracharge['id_dhl_extracharge'];
            $post['extracharge_'.$idDhlExtracharge] = (int)$extracharge['active'];
        }
        $post['pdf_name_submitted'] = '';
        $post['dhl_id_order'] = $order->id;
        $post['dhl_label_currency_iso'] = $currency->iso_code;
        $post['dhl_sender_address'] = $defaultSenderAddrDelivery;
        $post['dhl_customer_address'] = $order->id_address_delivery;
        $post['dhl_label_package_type'] = $labelType;
        $post['dhl_package_weight_1'] = $dhlPackage->weight_value;
        $post['dhl_package_length_1'] = $dhlPackage->length_value;
        $post['dhl_package_width_1'] = $dhlPackage->width_value;
        $post['dhl_package_depth_1'] = $dhlPackage->depth_value;
        $post['package_dimensions[]'] = $dim;
        $post['dhl_reference_id'] = $order->id;
        $post['dhl_label_contents'] = $defaultShipmentContent;
        $post['dhl_print_doc_archive'] = 0;
        $post['dhl_sending_doc'] = 0;
        $post['dhl_label_declared_value'] = number_format($order->total_paid_tax_incl, 2, '.', '');
        $post['dhl_label_insured_value'] = '';
        $post['dhl-number-pieces-concerned-1'] = '';
        $post['dhl-number-pieces-concerned-2'] = '';
        $post['dhl-number-pieces-concerned-3'] = '';
        $post['dhl-number-pieces-concerned-4'] = '';
        $post['TYPE_DESIGNATION_UN_XXXX'] = '';
        $post['dhl-number-pieces-concerned-5'] = '';
        $post['dhl-number-pieces-concerned-6'] = '';
        $post['dhl-number-pieces-concerned-7'] = '';
        $post['dhl-number-pieces-concerned-8'] = '';
        $post['dhl-number-pieces-concerned-9'] = '';
        $post['dhl-number-pieces-concerned-10'] = '';
        $post['dhl-number-pieces-concerned-11'] = '';
        $post['dhl-total-pieces-concerned2'] = 1;

        return $post;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'dhl';
    }
    
    /**
     * Genera la etiqueta. Hecho para usar con llamada externa.
     */
    public function generarEtiquetaRemoto() {
        $psAdminDir = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ADMIN');
        if(!defined('_PS_ADMIN_DIR_')) {
            define('_PS_ADMIN_DIR_', $psAdminDir);
            define('_PS_BO_ALL_THEMES_DIR_', _PS_ADMIN_DIR_.'/themes/');
        }
	
        require_once(_PS_MODULE_DIR_ . 'dhlexpress/controllers/admin/AdminDhlLabel.php');
        
        $sql = 'SELECT id_employee FROM ' . _DB_PREFIX_ . 'employee WHERE id_profile=1 AND active=1';
        $idEmployee = Db::getInstance()->getValue($sql);
        Context::getContext()->employee = new Employee($idEmployee);
		Cache::store('isLoggedBack' . $idEmployee, true);
        Context::getContext()->smarty->addTemplateDir(dirname(__FILE__).'/../../views/admin', 1);

        $controlador = new AdminDhlLabelController();
        $controlador->module = $this->modulo;
        $controlador->ajaxProcessGenerateFormLabel();
    }
    
    /**
     * Muestra el listado de productos de DHL.
     */
    public function obtenerProductosDhl() {
        $psAdminDir = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ADMIN');
        if(!defined('_PS_ADMIN_DIR_')) {
            define('_PS_ADMIN_DIR_', $psAdminDir);
            define('_PS_BO_ALL_THEMES_DIR_', _PS_ADMIN_DIR_.'/themes/');
        }
        
        require_once(_PS_MODULE_DIR_ . 'dhlexpress/controllers/admin/AdminDhlLabel.php');
        
        $sql = 'SELECT id_employee FROM ' . _DB_PREFIX_ . 'employee WHERE id_profile=1 AND active=1';
        $idEmployee = Db::getInstance()->getValue($sql);
        Context::getContext()->employee = new Employee($idEmployee);
        Cache::store('isLoggedBack' . $idEmployee, true);
        Context::getContext()->smarty->addTemplateDir(dirname(__FILE__).'/../../views/admin', 1);

        $controlador = new AdminDhlLabelController();
        $controlador->module = $this->modulo;
        $controlador->ajaxProcessRetrieveDhlService();
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
