<?php
/*
 * Crea la etiqueta de DbSchenker.
 */
class GeneradorEtiquetaDbSchenker extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        try {
            if (Module::isInstalled('imaxdbschenkercarrier')) {
                if (!is_file(dirname(__FILE__) . '/../../../imaxdbschenkercarrier/pdf/' . $pedido->id . '.pdf')) {
                    try {
                        $configuracion = $this->cargarConfiguracion();
                        $bultosManualesDb = $configuracion->bultosManuales;
                        $numBultos = $bultosManuales->obtenerBultosManuales();
                        if(!$bultosManualesDb || $numBultos) {
                            $imaxdbschenkercarrier = Module::getInstanceByName('imaxdbschenkercarrier');
                            $imaxdbschenkercarrier->hookActionOrderStatusPostUpdate(array('id_order' => $pedido->id), true, ($numBultos ? $numBultos : 1));
                        }
                    }
                    catch(Exception $ex) { }
                }

                if (is_file(dirname(__FILE__) . '/../../../imaxdbschenkercarrier/pdf/' . $pedido->id . '.pdf')) {
                    $bultosManuales->marcarBultosManualesDescargados();

                    return file_get_contents(dirname(__FILE__) . '/../../../imaxdbschenkercarrier/pdf/' . $pedido->id . '.pdf');
                }
            }
        }
        catch (Exception $ex) { }

        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'dbschenker';
    }
    
    /**
     * {@inheritDoc}
     */
    public function obtenerBultosBloqueados($pedido) {
        $bultosManuales = new BultosManuales($pedido->id);
        $datosBultos = $bultosManuales->obtenerDatosBultosManuales();
        return (boolean)($datosBultos ? $datosBultos['descargado'] || 
                is_file(dirname(__FILE__) . '/../../../imaxdbschenkercarrier/pdf/' . $pedido->id . '.pdf') : false);
    }

}
