<?php
/*
 * Crea la etiqueta de CTT.
 */
class GeneradorEtiquetaCtt extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $datosTemp = false;
        
        try {
            if (Module::isInstalled('cttexpress')) {
                $configuracion = $this->cargarConfiguracion();
                if($configuracion->bultosManuales) {
                    $bultos = $bultosManuales->obtenerBultosManuales();
                }
                else {
                    $bultos = 0;
                }
                $url = 'http://' . ImaxImprimePedidosServidor::getDomain() . '/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=generarEtiquetaCtt&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS');
                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('id_order' => $pedido->id, 'bultos' => $bultos)));
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
                curl_setopt($ch, CURLOPT_TIMEOUT, 360);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                $datosTemp = curl_exec($ch);
                $infoCurl = curl_getinfo($ch);

                $numIntentos = 0;
                while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                    curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                    $datosTemp = curl_exec($ch);
                    $infoCurl = curl_getinfo($ch);

                    $numIntentos++;
                }

                curl_close($ch);

                if ($datosTemp) {
                    if($infoCurl['http_code'] != 200) {
                        $this->errorEtiqueta = $datosTemp;
                        $datosTemp = false;
                    }
                }
            }
        } catch (Exception $ex) {
            
        }

        return $datosTemp;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'ctt';
    }
    
    /**
     * Genera la etiqueta. Hecho para usar con llamada externa.
     * @param int $id_order
     */
    public function generarEtiquetaRemoto($id_order) {
        chdir(dirname(__FILE__) . '/../../../');
        require_once dirname(__FILE__) . '/../../../cttexpress/controllers/admin/AdminTourlineexpressController.php';
        
        $sql = 'SELECT id_employee FROM ' . _DB_PREFIX_ . 'employee WHERE id_profile=1 AND active=1';
        $idEmployee = Db::getInstance()->getValue($sql);
        Context::getContext()->employee = new Employee($idEmployee);
        Cache::store('isLoggedBack' . $idEmployee, true);
        
        $pedido = new Order($id_order);
        $cttDatos = Db::getInstance()->getValue('SELECT file_name FROM `'._DB_PREFIX_ . "texpress_preregister` WHERE id_order = '$pedido->id'");
        if($cttDatos && is_file(__DIR__."/../../../cttexpress/pdftmp/$cttDatos")) {
            //Ya disponemos de ella
            $resultado = Hook::exec('tourlineexpressPrintLabels', array('orders' => [$pedido]), null, true);
            if($resultado['cttexpress']['code'] < 0) {
                header("HTTP/1.1 500 Internal Server Error");
                echo $resultado['cttexpress']['error'];
            }
        }
        else {
            //La generamos
            if(Tools::getValue('bultos')) {
                $_GET['texpress_package_count_hidden'] = Tools::getValue('bultos');
            }
            $controlador = new AdminTourlineexpressController();
            Hook::exec('actionAdminBulkgenerateTourlineShipmentsorderBefore', array('controller' => $controlador, 'order_ids' => [$pedido->id]));
            if($controlador->errors) {
                header("HTTP/1.1 500 Internal Server Error");
                echo implode(' ', $controlador->errors);
            }
            else {
                $resultado = Hook::exec('tourlineexpressPrintLabels', array('orders' => [$pedido]), null, true);
                if($resultado['cttexpress']['code'] < 0) {
                    header("HTTP/1.1 500 Internal Server Error");
                    echo $resultado['cttexpress']['error'];
                }
            }
        }
        exit;
    }
    
    /**
     * {@inheritDoc}
     */
    public function obtenerBultosBloqueados($pedido) {
        $cttDatos = Db::getInstance()->getValue('SELECT file_name FROM `'._DB_PREFIX_ . "texpress_preregister` WHERE id_order = '$pedido->id'");
        return ($cttDatos && is_file(__DIR__."/../../../cttexpress/pdftmp/$cttDatos"));
    }
}
