<?php
/**
 * Crea la etiqueta de Correos paq ligero.
 */
class GeneradorEtiquetaCorreosPaqLigero extends GeneradorEtiqueta {
    
    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $datos = false;
        
        $correos = Module::getInstanceByName('imaxcorreospaqligero');
        if($correos) {
            if(!is_file(dirname(__FILE__)."/../../imaxcorreospaqligero/etiquetas/$pedido->reference.pdf")) {
                //Generamos la etiqueta
                $correos->getFunciones()->preRegistrar($pedido);
            }
            
            if (is_file(dirname(__FILE__)."/../../imaxcorreospaqligero/etiquetas/$pedido->reference.pdf")) {
                //Listo
                $datos = file_get_contents(dirname(__FILE__)."/../../imaxcorreospaqligero/etiquetas/$pedido->reference.pdf");
            }
        }
        
        return $datos;
    }
    
    /**
     * {@inheritDoc}
     */
    public function cargarConfiguracion() {
        if(is_file(dirname(__FILE__).'/../../imaxcorreospaqligero/imaxcorreospaqligero.php')) {
            require_once dirname(__FILE__).'/../../imaxcorreospaqligero/imaxcorreospaqligero.php';
            $correosPaqLigero = [Configuration::getGlobalValue(ImaxCorreosPaqLigero::prefijo.'CARRIER_REF')];
        }
        else {
            $correosPaqLigero = [];
        }
        
        $configuracion = parent::cargarConfiguracion();
        $configuracion->idsReference = $correosPaqLigero;
        return $configuracion;
    }

    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        
        $acordeonCorreosPaqLigero = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', 
                $this->modulo->l('Estado de los pedidos de Correos Paq Ligero despues de generar la etiqueta:'), $estadosAdaptados, 
                $configuracion->nuevoEstado);
        return $acordeonCorreosPaqLigero->renderAcordeon($this->modulo->l('Correos pag ligero'), $formInterno->renderForm(true), true);
    }
    
    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'correos_paq_ligero';
    }
}
