<?php
/*
 * Crea la etiqueta de Correos Express.
 */
class GeneradorEtiquetaCorreosExpress extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $correos = Module::getInstanceByName('correosexpress');
        if($correos) {
            $configuracion = $this->cargarConfiguracion();
            if(version_compare($correos->version, '2.0', '>=')) {
                //Modulo de IT Department
                $inversa = (boolean)$configuracion->inversaCex;
				$datos = $this->enviarDatosNuevoFormulario($pedido, $correos->version, $inversa);
            }
            else {
                //Modulo de Studi7
                $fileName = "{$pedido->id}_{$pedido->reference}";
        
                $archivo = glob(dirname(__FILE__) . "/../../../correosexpress/barcodes/*/{$pedido->id}_{$pedido->reference}.ini");
                if (!$archivo) {
                    //Buscamos si existe con el nombre original
                    $archivo = glob(dirname(__FILE__) . "/../../../correosexpress/barcodes/*/$pedido->id.ini");
                    if($archivo) {
                        $fileName = $pedido->id;
                    }
                }
                if (!$archivo) {
                    //Lo enviamos a correos express
                    if ($this->enviarDatosFormulario($pedido)) {
                        $archivo = glob(dirname(__FILE__) . "/../../../correosexpress/barcodes/*/{$pedido->id}_{$pedido->reference}.ini");
                    }
                }

                if ($archivo) {
                    //En la nueva version de correos express hay que enviar una solicitud nueva para tener codigo de barras
                    $this->enviarDatosFormularioEtiqueta($fileName);

                    $fecha = explode('/', $archivo[0]);
                    $fechaString = $fecha[count($fecha) - 2];
                    $ch = curl_init('http://' . ImaxImprimePedidosServidor::getDomain() . "/modules/correosexpress/barcode_pdf.php?file_names=$fileName&date_f=$fechaString&pdfType=3&position=1");
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                    curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 360);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                    $datos = curl_exec($ch);
                    $infoCurl = curl_getinfo($ch);

                    $numIntentos = 0;
                    while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                        curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                        $datos = curl_exec($ch);
                        $infoCurl = curl_getinfo($ch);

                        $numIntentos++;
                    }

                    curl_close($ch);
                } 
                else {
                    $datos = false;
                }
            }
        }
        else {
            $datos = false;
        }
        
        return $datos;
    }
    
    /**
     * Graba la recogida y devuelve la etiqueta.
     * @param Order $pedido
     * @param string $version
     * @param boolean $inversa
     * @return string
     */
    private function enviarDatosNuevoFormulario($pedido, $version, $inversa = false) {
        //Datos base para el formulario
        if(version_compare($version, '2.4.8', '>=')) {
            $token = Tools::getAdminToken('AdminInicio');
        }
        else {
            $token = Configuration::get('CEX_TOKEN');
        }
        $datos = json_decode($this->enviarNuevoFormularioCorreos(array('id' => $pedido->id, 'action' => 'cexFormOrderTemplate',
            'language' => Configuration::get('PS_LANG_DEFAULT'), 'id_language' => Configuration::get('PS_LANG_DEFAULT'), 'token' => $token, 'id_shop' => $pedido->id_shop, 
            'id_shop_group' => $pedido->id_shop_group)), true);
        $opciones = $this->opcionesNuevoCorreosExpres();
        $configuracion = $this->cargarConfiguracion();

        $codigoEnvio = $this->obtenerCodigoEnvio($datos['datosEnvio']['postcode']);
        if ($codigoEnvio) {
            $shipMode = $codigoEnvio;
			$shipName = '';
			try {
				$shipName = Db::getInstance()->getValue('SELECT name FROM `' . _DB_PREFIX_ . "cex_savedmodeships` WHERE id_bc = '$codigoEnvio'");
			}
			catch(Exception $ex) {
				$shipName = '';
			}

			if(!$shipName) {
				try {
					$shipName = Db::getInstance()->getValue('SELECT name FROM `' . _DB_PREFIX_ . "savedmodeships` WHERE id_bc = '$codigoEnvio'");
				}
				catch(Exception $ex) {
					$shipName = '';
				}
			}
        } 
        else {
            $shipMode = 0;
            $shipName = '';
			$resultsCarrier = array();

			try {
				$resultsCarrier = Db::getInstance()->executeS('SELECT * FROM `' . _DB_PREFIX_ . 'cex_savedmodeships` WHERE checked = 1');
			}
			catch(Exception $ex) {
				$resultsCarrier = array();
			}
			
			if(!$resultsCarrier) {
				try {
					$resultsCarrier = Db::getInstance()->executeS('SELECT * FROM `' . _DB_PREFIX_ . 'savedmodeships` WHERE checked = 1');
				}
				catch(Exception $ex) {
					$resultsCarrier = array();
				}
			}
			
            if ($resultsCarrier) {
                foreach ($resultsCarrier as $row) {
                    $arrCarriers = explode(';', $row['id_carrier']);
                    if (in_array($pedido->id_carrier, $arrCarriers)) {
                        $shipMode = $row['id_bc'];
                        $shipName = $row['name'];
                        break;
                    }
                }
            }
        }

        $finalName = '';
        if ($datos['datosEnvio']['company'] != NULL || $datos['datosEnvio']['company'] != '') {
            $finalName = $datos['datosEnvio']['company'];
        } else {
            $finalName = $datos['datosEnvio']['firstname'] . ' ' . $datos['datosEnvio']['lastname'];
        }

		$pago = Module::getInstanceByName($pedido->module);
        if ($pago && $opciones['MXPS_DEFAULTPAYBACK'] == $pago->id) {
            $paybackVal = round($pedido->total_paid, 2);
            $payback = 'true';
        } else {
            $paybackVal = 0;
            $payback = 'false';
        }

        if ($configuracion->etiqXprod) {
            //Una etiqueta por producto
            $usarProductPackage = $configuracion->usarProductPackage;
            $productPackagePresente = Module::isEnabled('trzproductpackage');
            $detalles = $pedido->getProductsDetail();
            $bultos = 0;
            foreach ($detalles AS $detalle) {
                if($productPackagePresente && $usarProductPackage) {
                    $multiplo = $this->obtenerPaquetesTRZ($detalle['product_id']);
                }
                else {
                    $multiplo = 1;
                }

                $bultos += $detalle['product_quantity'] * $multiplo;
            }
        }
        else {
            //Bultos manuales
            if($configuracion->bultosManuales) {
                $bultos = $this->modulo->obtenerBultos($pedido->id);
            }
            //Bultos por defecto
            if(empty($bultos)) {
                $bultos = $opciones['MXPS_DEFAULTBUL'];
            }
        }
        
        if($datos['datosOficina']) {
            $entrega_oficina = 'true';
            $codigo_oficina = $datos['datosOficina']['codigo_oficina'];
            $text_oficina = $datos['datosOficina']['texto_oficina'];
        }
        else {
            $entrega_oficina = 'false';
            $codigo_oficina = '';
            $text_oficina = '';
        }
        
        $telefonoFalso = $this->obtenerTelefonoFalso($pedido);
        if(!$datos['datosEnvio']['movil'] && !$datos['datosEnvio']['telf'] && $telefonoFalso) {
            $telefonoDestinatario1 = $telefonoFalso;
            $telefonoDestinatario2 = '';
            $email = '';
        }
        else {
            $telefonoDestinatario1 = $datos['datosEnvio']['movil'];
            if(!$telefonoDestinatario1) {
                $telefonoDestinatario1 = $datos['datosEnvio']['telf'];
                $telefonoDestinatario2 = '';
            }
            else {
                $telefonoDestinatario2 = $datos['datosEnvio']['telf'];
            }
            if(!$telefonoFalso) {
                $email = substr($datos['datosEnvio']['email'], 0, strrpos($datos['datosEnvio']['email'], '.') + 4);
            }
            else {
                $email = '';
            }
        }
        
        if($inversa) {
            $direccion = new Address($pedido->id_address_delivery);

            $name_sender = $datos['datosEnvio']['first_name'].' '.$datos['datosEnvio']['last_name'];
            $contact_sender = $finalName;
            $address_sender = $datos['datosEnvio']['address'].' '.$datos['datosEnvio']['address2'];
            $postcode_sender = $datos['datosEnvio']['postcode'];
            $city_sender = $datos['datosEnvio']['city'];
            $country_sender = $datos['datosEnvio']['country'];
            $iso_code_remitente = Country::getIsoById($direccion->id_country);
            $phone_sender = str_replace('+', '', ($telefonoDestinatario1 ? $telefonoDestinatario1 : $telefonoDestinatario2));
            $email_sender = $email;
            $name_receiver = $datos['selectRemitentes'][0]['name'];
            $contact_receiver = $datos['selectRemitentes'][0]['contact'];
            $address_receiver = $datos['selectRemitentes'][0]['address'];
            $postcode_receiver = $datos['selectRemitentes'][0]['postcode'];
            $city_receiver = $datos['selectRemitentes'][0]['city'];
            $phone_receiver1 = str_replace('+', '', $datos['selectRemitentes'][0]['phone']);
            $phone_receiver2 = '';
            $email_receiver = $datos['selectRemitentes'][0]['email'];
            $country_receiver = Country::getNameById(Configuration::get('PS_LANG_DEFAULT'), Country::getByIso($datos['selectRemitentes'][0]['iso_code_pais']));
            if(Module::isEnabled('amazon') && $configuracion->referenciaAmazon){
                $referenciaAmazon = Db::getInstance()->getValue('Select mp_order_id from `'._DB_PREFIX_.'marketplace_orders` where id_order = ' . $pedido->id);
                $separadorAmazon = $configuracion->separadorAmazon;
                if(!$configuracion->refOrId){
                    $numcollect = $pedido->reference . $separadorAmazon . $referenciaAmazon.'_inv';
                }else{
                    $numcollect = $pedido->id . $separadorAmazon . $referenciaAmazon.'_inv';
                }
            }else{
                $numcollect = "{$pedido->id}_{$pedido->reference}_inv";
            }
        }
        else {
            $name_sender = $datos['selectRemitentes'][0]['name'];
            $contact_sender = $datos['selectRemitentes'][0]['contact'];
            $address_sender = $datos['selectRemitentes'][0]['address'];
            $postcode_sender = $datos['selectRemitentes'][0]['postcode'];
            $city_sender = $datos['selectRemitentes'][0]['city'];
            $country_sender = Country::getNameById(Configuration::get('PS_LANG_DEFAULT'), Country::getByIso($datos['selectRemitentes'][0]['iso_code_pais']));
            $iso_code_remitente = $datos['selectRemitentes'][0]['iso_code_pais'];
            $phone_sender = str_replace('+', '', $datos['selectRemitentes'][0]['phone']);
            $email_sender = $datos['selectRemitentes'][0]['email'];
            $name_receiver = $datos['datosEnvio']['first_name'].' '.$datos['datosEnvio']['last_name'];
            $contact_receiver = $finalName;
            $address_receiver = $datos['datosEnvio']['address'].' '.$datos['datosEnvio']['address2'];
            $postcode_receiver = $datos['datosEnvio']['postcode'];
            $city_receiver = $datos['datosEnvio']['city'];
            $phone_receiver1 = str_replace('+', '', $telefonoDestinatario1);
            $phone_receiver2 = str_replace('+', '', $telefonoDestinatario2);
            $email_receiver = $email;
            $country_receiver = $datos['datosEnvio']['country'];
            $numcollect = $this->obtenerNumCollect($configuracion, $pedido);
        }
		
        //Datos del formulario
        $datosFinal = array(
            "action" => "cexFormPedido",
            "id" => $pedido->id,
            "token" => $token,
            "loadSender" => "1",
            "name_sender" => $name_sender,
            "contact_sender" => $contact_sender,
            "address_sender" => $address_sender,
            "postcode_sender" => $postcode_sender,
            "city_sender" => $city_sender,
            "country_sender" => $country_sender,
            "iso_code_remitente" => $iso_code_remitente,
            "phone_sender" => $phone_sender,
            "email_sender" => $email_sender,
            "grabar_recogida" => 'false',
            "note_collect" => '',
            "loadReceiver" => 'false',
            "name_receiver" => trim(mb_substr(trim($name_receiver), 0, 40)),
            "contact_receiver" => trim(mb_substr(trim($contact_receiver), 0, 40)),
            "address_receiver" => $address_receiver,
            "postcode_receiver" => $postcode_receiver,
            "city_receiver" => $city_receiver,
            "phone_receiver1" => $phone_receiver1,
            "phone_receiver2" => $phone_receiver2,
            "email_receiver" => $email_receiver,
            "country_receiver" => $country_receiver,
            "note_deliver" => trim(mb_substr(trim($configuracion->incluirRefs ? $this->generarReferenciasString($pedido) : $pedido->getFirstMessage()), 0, 76)),
            "id_codigo_cliente" => $datos['selectCodCliente'][0]['id'],
            "codigo_cliente" => $datos['selectCodCliente'][0]['customer_code'],
            "codigo_solicitante" => $datos['selectCodCliente'][0]['code_demand'],
            "datepicker" => date('Y-m-d'),
            "fromHH_sender" => '',
            "fromMM_sender" => '',
            "toHH_sender" => '',
            "toMM_sender" => '',
            "ref_ship" => $numcollect,
            "desc_ref_1" => '',
            "desc_ref_2" => '',
            "selCarrier" => $shipMode,
            "nombre_modalidad" => $shipName,
            "deliver_sat" => 'false',
            "iso_code" => $datos['paisOrden'],
            "entrega_oficina" => $entrega_oficina,
            "codigo_oficina" => $codigo_oficina,
            "text_oficina" => $text_oficina,
            "payback_val" => $paybackVal,
            "insured_value" => '',
            "bultos" => $bultos,
            "kilos" => $opciones['MXPS_ENABLEWEIGHT'] == "true" ? $opciones['MXPS_DEFAULTKG'] : 0,
            "contrareembolso" => $payback,
            'modificacionAutomatica' => false,
            'at_portugal' => '',
            'tipoEtiqueta' => 3,
            'idiomaContexto' => Configuration::get('PS_LANG_DEFAULT')
        );

        $saved = $this->esSaved($numcollect);        
        if(!$saved) {
            $respuesta = $this->enviarNuevoFormularioCorreos($datosFinal);
            if($respuesta){
                $respuesta = json_decode($respuesta, true);
                if(!$respuesta['resultado'] && $respuesta['mensajeRetorno']) {
                    $this->errorEtiqueta = $respuesta['mensajeRetorno'];
                }
            } else {
                $this->errorEtiqueta = $this->modulo->l('No se recibió etiqueta.');
            }
        }
        else {
            $respuesta = false;
        }
     
        if($saved || ($respuesta && $respuesta['resultado'])) {
            //Solicitamos la etiqueta
            if(version_compare($version, '3.0.0', '>=')) {
                $datos = [
                    'action' => 'generarEtiquetasReimpresion',
                    'numCollect[]' => $numcollect,
                    'tipoEtiqueta' => 3,
                    'tipoReimpresion' => 2,
                    'posicion' => 1,
                    'token' => $token
                ];
                
                $etiquetaTemp = $this->enviarNuevoFormularioCorreos($datos);
                if($etiquetaTemp) {
                    $etiquetaTemp = json_decode($etiquetaTemp);
                    if($etiquetaTemp && !empty($etiquetaTemp->etiquetas)) {
                        $etiqueta = base64_decode($etiquetaTemp->etiquetas[0]);
                    }
                    else {
                        $etiqueta = '';
                    }
                }
                else {
                    $etiqueta = '';
                }
            }
            else {
                $datos = [
                    'action' => 'generarEtiquetas',
                    'numCollect' => $numcollect,
                    'tipoEtiqueta' => 3,
                    'token' => $token
                ];
                
                $etiqueta = $this->enviarNuevoFormularioCorreos($datos);
                if($etiqueta) {
                    $etiqueta = base64_decode(str_replace("\r\n", '', mb_substr($etiqueta, 153)));
                }
            }
        }
		else {
			$etiqueta = false;
		}
        
		return $etiqueta;
    }
    
    /**
     * Envia los datos solicitando la etiqueta.
     * @param string $identificadorPedido
     * @return boolean
     */
    private function enviarDatosFormularioEtiqueta($identificadorPedido) {
        $resultado = false;

        $datosFinales['AbsPath'] = dirname(__FILE__) . '/../../../correosexpress/';
        $datosFinales['codelist'] = $identificadorPedido . ',';
        $datosFinales['date'] = date("d-m-Y");
        $datosFinales['grouping'] = 'true';
        $datosFinales['grouping_state'] = 'send_from_labels';
        $datosFinales['mode'] = 'saveShip';
        $datosFinales['path'] = '/modules/correosexpress/';
        $datosFinales['pdfType'] = 3;
        $datosFinales['position'] = 1;
        $datosFinales['telephone'] = '';

        //Enviamos
        $params = '';
        foreach ($datosFinales as $key => $value) {
            $params .= $key . '=' . urlencode($value) . '&';
        }

        $params = trim($params, '&');

        $ch = curl_init('http://' . ImaxImprimePedidosServidor::getDomain() . "/modules/correosexpress/ajax.php?$params");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);

        $numIntentos = 0;
        while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
            curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url'] . "?$params");
            $datos = curl_exec($ch);
            $infoCurl = curl_getinfo($ch);

            $numIntentos++;
        }

        curl_close($ch);

        if ($numIntentos < 10 && $infoCurl['http_code'] == 200) {
            $datos = json_decode($datos, true);
            if ($datos['code'] != '-1') {
                $resultado = true;
            }
        }

        return $resultado;
    }
    
    /**
     * Envia los datos del pedido al modulo de Correos express para que los envie a Correos.
     * @param Order $pedido
     * @return boolean
     */
    private function enviarDatosFormulario($pedido) {
        $resultado = false;
        $datosFinales = array();

        if ($this->isCarrierMapped($pedido->id_carrier)) {
            $configuracion = $this->cargarConfiguracion();
            //Remitente
            $data = $this->getSenderData(Configuration::get('MXPS_DEFAULTSEND'));
            $sender = $data[0];

            $datosFinales['id_order'] = $pedido->id;
            $datosFinales['sender'] = $sender['name'];
            $datosFinales['idsender'] = Configuration::get('MXPS_DEFAULTSEND');
            $datosFinales['contact_sender'] = $sender['contact'];
            $datosFinales['address_sender'] = $sender['address'];
            $datosFinales['postcode_sender'] = $sender['postcode'];
            $datosFinales['city_sender'] = $sender['city'];
            $datosFinales['phone_sender'] = $sender['phone'];
            $datosFinales['email_sender'] = Configuration::get('PS_SHOP_EMAIL');
            $datosFinales['note_collect'] = '';


            //Destinatario
            $customer = new Customer((int) $pedido->id_customer);
            $sql = 'SELECT a.* FROM `' . _DB_PREFIX_ . 'address` a INNER JOIN `' . _DB_PREFIX_ . 'orders` o ON a.id_address = o.id_address_delivery WHERE o.id_order = ' . $pedido->id;
            $results = Db::getInstance()->ExecuteS($sql);

            $codigoEnvio = $this->obtenerCodigoEnvio($results[0]['postcode']);
            if ($codigoEnvio) {
                $shipMode = $codigoEnvio;
                $shipName = Db::getInstance()->getValue('SELECT name FROM `' . _DB_PREFIX_ . "savedmodeships` WHERE id_bc = '$codigoEnvio'");
            } else {
                $shipMode = 0;
                $shipName = '';
                $shipModesEnabled = Configuration::get('MXPS_SELMODESHIP');
                $sm_array = explode(",", $shipModesEnabled);

                $sqlCarrier = 'SELECT * FROM `' . _DB_PREFIX_ . 'savedmodeships`';
                if ($resultsCarrier = Db::getInstance()->ExecuteS($sqlCarrier)) {
                    foreach ($resultsCarrier as $row) {
                        if (in_array($row['id_bc'], $sm_array)) {
                            $arrCarriers = explode(',', $row['id_carrier']);
                            if (in_array($pedido->id_carrier, $arrCarriers)) {
                                $shipMode = $row['id_bc'];
                                $shipName = $row['name'];
                                break;
                            }
                        }
                    }
                }
            }

            $finalName = '';
            if ($results[0]['company'] != NULL || $results[0]['company'] != '') {
                $finalName = $results[0]['company'];
            } else {
                $finalName = $results[0]['firstname'] . ' ' . $results[0]['lastname'];
            }

            if (Configuration::get('MXPS_DEFAULTPAYBACK') == $pedido->module) {
                $paybackVal = round($pedido->total_paid, 2);
                $payback = 'true';
            } else {
                $paybackVal = 0;
                $payback = 'false';
            }

            $telefono = $results[0]['phone_mobile'];
            if (!$telefono) {
                $telefono = $results[0]['phone'];
                if (!$telefono) {
                    $telefono = $sender['phone'];
                }
            }

            $datosOficina = $this->getOfficeDataSelect($pedido->id);
            if ($configuracion->etiqXprod) {
                //Etiqueta por producto
                $usarProductPackage = $configuracion->usarProductPackage;
                $productPackagePresente = Module::isEnabled('trzproductpackage');
                $detalles = $pedido->getProductsDetail();
                $bultos = 0;
                foreach ($detalles AS $detalle) {
                    if($productPackagePresente && $usarProductPackage) {
                        $multiplo = $this->obtenerPaquetesTRZ($detalle['product_id']);
                    }
                    else {
                        $multiplo = 1;
                    }

                    $bultos += $detalle['product_quantity'] * $multiplo;
                }
            }
            else {
                //Bultos manuales
                if($configuracion->bultosManuales) {
                    $bultos = $this->modulo->obtenerBultos($pedido->id);
                }
                //Bultos por defecto
                if(empty($bultos)) {
                    $bultos = Configuration::get('MXPS_DEFAULTBUL');
                }
            }

            $datosFinales['date'] = date('d-m-Y');
            $datosFinales['ref_ship'] = $pedido->id.'_'.$pedido->reference;
            $datosFinales['num_ship'] = '';
            $datosFinales['receiver'] = $finalName;
            $datosFinales['contact_receiver'] = $results[0]['firstname'] . ' ' . $results[0]['lastname'];
            $datosFinales['address_receiver'] = $results[0]['address1'] . ' ' . $results[0]['address2'];
            $datosFinales['postcode_receiver'] = $results[0]['postcode'];
            $datosFinales['city_receiver'] = $results[0]['city'];
            $datosFinales['phone_receiver'] = $telefono;
            $datosFinales['telephone'] = $telefono;
            $datosFinales['email_receiver'] = $customer->email;
            $datosFinales['mode'] = 'saveShip';
            $datosFinales['mode_ship'] = $shipMode;
            $datosFinales['iso_code'] = Country::getIsoById($results[0]['id_country']);
            $datosFinales['payback'] = $payback;
            $datosFinales['payback_val'] = $paybackVal;
            $datosFinales['bultos'] = $bultos;
            $datosFinales['kilos'] = Configuration::get('MXPS_DEFAULTKG');
            $datosFinales['path'] = '/modules/correosexpress/';
            $datosFinales['mode_ship_name'] = $shipName;
            $datosFinales['note_deliver'] = mb_substr(trim($configuracion->incluirRefs ? $this->generarReferenciasString($pedido) : $pedido->getFirstMessage()), 0, 76);
            $datosFinales['devolution'] = 'false';
            $datosFinales['fromHH_sender'] = '10';
            $datosFinales['fromMM_sender'] = '00';
            $datosFinales['toHH_sender'] = '20';
            $datosFinales['toMM_sender'] = '00';
            $datosFinales['deliver_sat'] = 'false';
            $datosFinales['desc_ref_1'] = '';
            $datosFinales['desc_ref_2'] = '';
            $datosFinales['AbsPath'] = dirname(__FILE__) . '/../../../correosexpress/';
            $datosFinales['gbr'] = 'false';
            $datosFinales['grouping_state'] = 'save';
            $datosFinales['grouping'] = 'true';
            $datosFinales['mailLabel'] = 'false';
            $datosFinales['group_others'] = 'false';
            $datosFinales['id_ships_to_group'] = '';
            if ($datosOficina) {
                $data_oficina_front = explode("#!#", $datosOficina['codigo_oficina']);

                $datosFinales['entrega_oficina'] = 'true';
                $datosFinales['codigo_oficina_entrega'] = $data_oficina_front[0];
                $datosFinales['dir_oficina'] = $data_oficina_front[1];
                $datosFinales['nombre_oficina'] = $data_oficina_front[2];
                $datosFinales['codPostal_oficina'] = $data_oficina_front[3];
                $datosFinales['pob_oficina'] = $data_oficina_front[4];
            } else {
                $datosFinales['entrega_oficina'] = 'false';
            }

            //Enviamos
            $params = '';
            foreach ($datosFinales as $key => $value) {
                $params .= $key . '=' . urlencode($value) . '&';
            }

            $params = trim($params, '&');

            $ch = curl_init('http://' . ImaxImprimePedidosServidor::getDomain() . "/modules/correosexpress/ajax.php?$params");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 360);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            $datos = curl_exec($ch);
            $infoCurl = curl_getinfo($ch);

            $numIntentos = 0;
            while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url'] . "?$params");
                $datos = curl_exec($ch);
                $infoCurl = curl_getinfo($ch);

                $numIntentos++;
            }

            curl_close($ch);

            if ($numIntentos < 10 && $infoCurl['http_code'] == 200) {
                $datos = json_decode($datos, true);
                if ($datos['code'] != '-1') {
                    $resultado = true;
                }
            }
        }

        return $resultado;
    }
    
    /**
     * Envia datos al modulo de correos de IT Department.
     * @param array $post
     * @return mixed
     */
    private function enviarNuevoFormularioCorreos($post) {
		$url = 'http://' . ImaxImprimePedidosServidor::getDomain() . "/modules/correosexpress/index.php";
		
		$correos = Module::getInstanceByName('correosexpress');
        if($correos) {
            if(version_compare($correos->version, '2.3.7', '>=')) {
				$url = 'http://' . ImaxImprimePedidosServidor::getDomain() . "/modules/correosexpress/controllers/admin/index.php";
			}
		}
				
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);

        $numIntentos = 0;
        while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
            curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
            $datos = curl_exec($ch);
            $infoCurl = curl_getinfo($ch);

            $numIntentos++;
        }

        curl_close($ch);		

        return ($infoCurl['http_code'] == 200 ? $datos : false);
    }
    
    /**
     * Devuelve las opciones guardadas del nuevo modulo de correos expres.
     * @return array
     */
    private function opcionesNuevoCorreosExpres() {
        $opciones = array();
        
        try {
            $sql = 'SELECT clave, valor FROM `'._DB_PREFIX_.'cex_customer_options`';
            $results = Db::getInstance()->ExecuteS($sql);
        }
        catch(Exception $ex) {
            $results = array();
        }
        
        if(!$results) {
            try {
                $sql = 'SELECT clave, valor FROM `'._DB_PREFIX_.'customer_options`';
                $results = Db::getInstance()->ExecuteS($sql);
            }
            catch(Exception $ex) {
                $results = array();
            }   
        }
            
        foreach($results as $result) {
            $opciones[$result['clave']] = $result['valor'];
        }
        
        return $opciones;
    }
    
    /**
     * Devuelve el codigo de envio para un codigo postal.
     * @param int $codigoPostal
     */
    private function obtenerCodigoEnvio($codigoPostal) {
        require dirname(__FILE__) . '/../../configuration.php';

        $resultado = 0;

        foreach ($codigosPostalesTipoEnvio as $codigoEnvio => $codigoPostaleTipoEnvioGrupo) {
            foreach ($codigoPostaleTipoEnvioGrupo as $codigoPortalTipoEnvio) {
                if (stripos($codigoPortalTipoEnvio, '-')) {
                    //Es un tramo
                    $extremosPostales = explode('-', $codigoPortalTipoEnvio);
                    if ((int) trim($codigoPostal) >= (int) trim($extremosPostales[0]) && (int) trim($codigoPostal) <= (int) trim($extremosPostales[1])) {
                        $resultado = $codigoEnvio;
                        break 2;
                    }
                } else {
                    //Es unico
                    if ((int) trim($codigoPostal) == (int) trim($codigoPortalTipoEnvio)) {
                        $resultado = $codigoEnvio;
                        break 2;
                    }
                }
            }
        }

        return $resultado;
    }
    
    /**
     * verify if order carrier has been mapped in configuration.
     * @param int $idcarr
     * @return bool
     */
    private function isCarrierMapped($idcarr) {
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'savedmodeships`';
        $ret = false;
        if ($results = Db::getInstance()->ExecuteS($sql)) {
            foreach ($results as $row) {
                $arrCarriers = explode(',', $row['id_carrier']);
                if (in_array($idcarr, $arrCarriers)) {
                    $ret = true;
                }
            }
        }

        return $ret;
    }
    
    /**
     * Devuelve los datos de envío.
     * @param int $id
     * @return array
     */
    private function getSenderData($id) {
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'savedsenders` WHERE id_sender = ' . $id;
        $result = Db::getInstance()->ExecuteS($sql);

        return $result;
    }
    
    /**
     * Envia un array con la información de la oficina escogida por el usuario desde el front.
     * @param int id_orden
     * @return array con la info
     */
    private function getOfficeDataSelect($id_order) {
        $sql_ent_ofi = "
            SELECT po.id_order,ofd.codigo_oficina FROM `" . _DB_PREFIX_ . "orders` po 
                INNER JOIN `" . _DB_PREFIX_ . "officedeliverycorreo` ofd ON (po.id_cart = ofd.id_cart) 
            WHERE po.id_order = '$id_order'";

        return Db::getInstance()->getRow($sql_ent_ofi);
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'correos_express';
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', 
                $this->modulo->l('Selecciona los transportistas de Correos Express:'), 
                $this->modulo->l('Selecciona los transportistas de Correos Express:'), $transportistasAdaptados, 
                $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', 
                $this->modulo->l('Estado de los pedidos de Correos Express despues de generar la etiqueta:'), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        $formInterno->createFormCheckboxGroup($prefijo.'[incluirRefs]', 
                $this->modulo->l('Incluir referencias de productos en el pedido si es Correos Express'), 
                $configuracion->incluirRefs);
        $formInterno->createFormCheckboxGroup($prefijo.'[etiqXprod]', 
                $this->modulo->l('Imprimir una etiqueta por cada producto de Correos Express'),
                $configuracion->etiqXprod);
        $formInterno->createFormCheckboxGroup($prefijo.'[bultosManuales]', $this->modulo->l('Numero de bultos manual'), 
                $configuracion->bultosManuales);
        $formInterno->createFormCheckboxGroup($prefijo.'[inversaCex]', 
                $this->modulo->l('Imprimir la etiqueta de devolucion de Correos Express conjuntamente con la normal'), 
                $configuracion->inversaCex);
        if(Module::isEnabled('amazon')){
            $formInterno->createFormSelect($prefijo.'[refOrId]', $this->modulo->l('Referencia o ID de producto en la etiqueta de Correos Express'), 
                    array('0' => $this->modulo->l('Referencia'), '1' => $this->modulo->l('ID de producto')), 
                    $configuracion->refOrId);
            $formInterno->createFormCheckboxGroup($prefijo.'[referenciaAmazon]', $this->modulo->l('Adicionar referencia amazon a la referencia de pedido'), 
                    $configuracion->referenciaAmazon);
            $formInterno->createFormTextGroup($prefijo.'[separadorAmazon]', 
                    $configuracion->separadorAmazon, 
                    $this->modulo->l('Separador para la referencia del pedido'));
        }
        if(Module::isEnabled('trzproductpackage')) {
            $formInterno->createFormCheckboxGroup($prefijo.'[usarProductPackage]', 
                    $this->modulo->l('Cantidad de etiquetas segun modulo Product Package (incluye la opcion anterior).'), 
                    $configuracion->usarProductPackage);
        }

        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
 
    /**
     * {@inheritDoc}
     */
    public function grabarConfiguracion($post) {
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        if(Tools::getValue($prefijo.'[usarProductPackage]')) {
            $_POST[$prefijo.'[etiqXprod]'] = true;
        }

        return parent::grabarConfiguracion($post);
    }
    
    /**
     * {@inheritDoc}
     */
    public function obtenerBultosBloqueados($pedido) {
        $configuracion = $this->cargarConfiguracion();
        return $this->esSaved($this->obtenerNumCollect($configuracion, $pedido));
    }

    /**
     * Devuelve el numcollect para 
     * @param ConfiguracionEtiqueta $configuracion
     * @param Order $pedido
     * @return string
     */
    private function obtenerNumCollect($configuracion, $pedido) {
        if(Module::isEnabled('amazon') && $configuracion->referenciaAmazon){
            $referenciaAmazon = Db::getInstance()->getValue('Select mp_order_id from '._DB_PREFIX_.'marketplace_orders where id_order = ' . $pedido->id);
            $separadorAmazon = $configuracion->separadorAmazon;
            if(!$configuracion->refOrId){
                $numcollect = $pedido->reference . $separadorAmazon . $referenciaAmazon;
            }else{
                $numcollect = $pedido->id . $separadorAmazon . $referenciaAmazon;
            }
        }
        else{
            $numcollect = "{$pedido->id}_{$pedido->reference}";
        }
        
        return $numcollect;
    }
    
    /**
     * Indica si el pedido está guardado.
     * @param string $numcollect
     * @return boolean
     */
    private function esSaved($numcollect) {
        try {
            $saved = Db::getInstance()->getValue('SELECT 1 FROM '._DB_PREFIX_."cex_savedships 
                        WHERE type='Envio' AND deleted_at is null AND numcollect = '$numcollect'");
        }
        catch(Exception $ex) {
            $saved = Db::getInstance()->getValue('SELECT 1 FROM '._DB_PREFIX_."savedships 
                    WHERE type='Envio' AND deleted_at is null AND numcollect = '$numcollect'");
        } 
        
        return (boolean)$saved;
    }
}
