<?php
/*
 * Crea la etiqueta de correos.
 */
class GeneradorEtiquetaCorreos extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $datosEtiqueta = false;

        if(Module::isEnabled('correosoficial')) {
            require_once __DIR__ . '/../../../correosoficial/classes/CorreosOficialCarrier.php';
            require_once __DIR__ . '/../../../correosoficial/classes/CorreosOficialSenders.php';
            require_once __DIR__ . '/../../../correosoficial/classes/CorreosOficialOrders.php';
            if(is_file(__DIR__ . '/../../../correosoficial/vendor/ecommerce_common_lib/Commons/NeedCustoms.php')) {
                require_once __DIR__ . '/../../../correosoficial/vendor/ecommerce_common_lib/Commons/NeedCustoms.php';
            }
            else {
                require_once __DIR__ . '/../../../correosoficial/ecommerce_common_lib/Commons/NeedCustoms.php';
            }
            
            $carrier = new Carrier($pedido->id_carrier);
            $customer = new Customer($pedido->id_customer);
            $address = new Address($pedido->id_address_delivery);
            $id_zone = Address::getZoneById($pedido->id_address_delivery);
            $idProducto = CorreosOficialCarrier::getCarriersProducts($pedido->id_carrier, $id_zone, $pedido->id_shop);
            if(method_exists('CorreosOficialCarrier', 'getCarrierById')) {
                $carrier_order = CorreosOficialCarrier::getCarrierById($idProducto['id_product']);
            }
            else {
                $carrier_order = CorreosOficialCarrier::getCarrierByProductId($idProducto['id_product']);
            }
            if(!$carrier_order && $carrier->external_module_name == 'correosoficial') {
                $carrier_order = CorreosOficialCarrier::getCarrier($pedido->id_carrier);
            }
            $default_sender = CorreosOficialSenders::getDefaultSender();
            $client_data = CorreosOficialCarrier::getClientCodeByCompany($carrier_order['company']);
            $numBultos = $bultosManuales->obtenerBultosManuales();
            $correos_request = CorreosOficialOrders::getRequestRecord($pedido->id);
            if ($carrier_order['product_type'] == 'office') {
                $parsed_data = json_decode($correos_request['data']);
                $cod_office = $parsed_data->unidad;
                $cod_homepaq = '';
            } 
            elseif ($carrier_order['product_type'] == 'citypaq') {
                $parsed_data = json_decode($correos_request['data']);
                $cod_office = '';
                $cod_homepaq = $parsed_data->cod_homepaq;
            }
            else {
                $cod_office = '';
                $cod_homepaq = '';
            }
            $telefonoFalso = $this->obtenerTelefonoFalso($pedido);
            if($telefonoFalso) {
                $phone = ($address->phone_mobile ? $address->phone_mobile : $address->phone);
                if(!$phone) {
                    $phone = $telefonoFalso;
                }
                $email = '';
            }
            else {
                $phone = ($address->phone_mobile ? $address->phone_mobile : $address->phone);
                $email = $customer->email;
            }
            $peso = substr($pedido->getTotalWeight() / ($numBultos ? $numBultos : 1), 0, 5);
            $aduana = NeedCustoms::isCustomsRequired($default_sender['sender_cp'], $address->postcode, $default_sender['sender_iso_code_pais'], 
                    Country::getIsoById($address->id_country));
            $infoBultos = [1 => [
                'reference' => $pedido->id,
                'weight' => $peso,
                'large' => 1,
                'width' => 1,
                'height' => 1, 
                'observations' => ''
            ]];

            $correosOficial = Module::getInstanceByName('correosoficial');
            $post = [];
            $post['accion'] = 'generarEtiquetaCorreosOficial';
            $post['order_id'] = $pedido->id;
            $post['id_carrier'] = $pedido->id_carrier;
            $post['id_product'] = (version_compare($correosOficial->version, '1.2.1', '>=') ? $idProducto['id_product'] : $carrier_order['codigoProducto']);
            $post['company'] = $carrier_order['company'];
            $post['delivery_mode'] = $carrier_order['product_type'];
            $post['info_bultos'] = json_encode($infoBultos);
            $post['order_form'] = [
                'cod_homepaq' => $cod_homepaq,
                'cod_office' => $cod_office,
                'input_cp_office' => '',
                'office_address' => '',
                'office_city' => '',
                'office_cp' => '',
                'input_cp_citypaq' => '',
                'citypaq_address' => '',
                'citypaq_city' => '',
                'citypaq_cp' => '',
                'custom_ref_exp' => '',
                'require_customs_doc' => $aduana,
                'code_at' => '',
                'all_packages_equal' => '',
                'packageAmount_1' => $pedido->total_products,
                'DescriptionRadio_1' => '0',
                'packageTariffCode_1' => '',
                'packageTariffDesc_1' => '',
                'cash_on_delivery_value' => '0',
                'bank_acc_number' => '',
                'insurance_value' => '',
                'partial_delivery' => '0',
                'delivery_saturday' => '0',
                'pickup_date' => '',
                'sender_from_time' => '',
                'sender_to_time' => '',
                'print_label' => '1',
                'return_pickup_date' => '',
                'return_sender_from_time' => '',
                'return_sender_to_time' => '',
                'return_print_label' => '0',
                'packageWeightReturn_1' => '',
                'packageAmountReturn_1' => '',
                'DescriptionRadioReturn_1' => '0',
                'packageTariffCodeReturn_1' => '',
                'packageTariffDescReturn_1' => '',
                'sender_name' => $default_sender['sender_name'],
                'sender_contact' => $default_sender['sender_contact'],
                'sender_address' => $default_sender['sender_address'],
                'sender_city' => $default_sender['sender_city'],
                'sender_cp' => $default_sender['sender_cp'],
                'sender_phone' => $default_sender['sender_phone'],
                'sender_email' => $default_sender['sender_email'],
                'sender_nif_cif' => $default_sender['sender_nif_cif'],
                'customer_firstname' => $this->reemplazarCaracteres($address->firstname),
                'customer_lastname' => $this->reemplazarCaracteres($address->lastname),
                'customer_company' => $this->reemplazarCaracteres($address->company),
                'customer_contact' => '',
                'customer_address' => $this->reemplazarCaracteres($address->address1.' '.$address->address2),
                'customer_city' => $this->reemplazarCaracteres($address->city),
                'customer_cp' => $address->postcode,
                'customer_phone' => $phone,
                'customer_email' => $email,
                'customer_dni' => ($address->dni ? $address->dni : $address->vat_number),
                'client_code' => $client_data['customer_code'],
                'order_reference' => $pedido->id,
                'order_number' => $pedido->id,
                'packageRef_1' => $pedido->id,
                'packageWeight_1' => $peso,
                'packageLarge_1' => '',
                'packageWidth_1' => '',
                'packageHeight_1' => '',
                'contrareembolsoCheckbox' => '0',
                'seguroCheckbox' => '0',
                'senderSelect' => $default_sender['id'],
                'sender_country' => $default_sender['sender_iso_code_pais'],
                'customer_country' => Country::getIsoById($address->id_country),
                'input_select_carrier' => $carrier_order['codigoProducto'],
                'correos-num-parcels' => ($numBultos ? $numBultos : 1),
                'packageCustomDesc_1' => '',
                'package_type' => '',
                'input_tipo_etiqueta_reimpresion' => '2',
                'input_pos_etiqueta_reimpresion' => '',
                'correos-num-parcels-return' => '1',
                'return_package_type' => '',
                'input_tipo_etiqueta_reimpresion_return' => '2',
                'input_pos_etiqueta_reimpresion_return' => '',
                'packageCustomDescReturn_1' => '',
                'deliveryRemarks_1' => '',
                'id_zone' => $id_zone
            ];
            if($aduana) {
                $customs_desc_selected = (int)Db::getInstance()->getValue('SELECT value FROM `'._DB_PREFIX_.'correos_oficial_configuration` 
                    WHERE name = "DefaultCustomsDescription"');
                $customs_desc = Db::getInstance()->getValue('SELECT description FROM `'._DB_PREFIX_."correos_oficial_customs_description` 
                    WHERE code = '$customs_desc_selected'");
                $post['order_form']['customs_desc[1'] = [$customs_desc_selected.' • '.$customs_desc.' • '.$pedido->total_products.' • '.
                        $pedido->getTotalWeight().' • '.count($pedido->getProducts())];
            }
            for($x=2;$x<=$numBultos;$x++) {
                $post['order_form']["packageRef_$x"] = $pedido->id;
                $post['order_form']["packageWeight_$x"] = $peso;
                $post['order_form']["packageLarge_$x"] = '';
                $post['order_form']["packageWidth_$x"] = '';
                $post['order_form']["packageHeight_$x"] = '';
                $post['order_form']["deliveryRemarks_$x"] = '';
            }

            $ch = curl_init('http://' . ImaxImprimePedidosServidor::getDomain() . '/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=generarEtiquetaCorreosOficial&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS'));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 360);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
            $datos = curl_exec($ch);
            $infoCurl = curl_getinfo($ch);

            $numIntentos = 0;
            while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                $datos = curl_exec($ch);
                $infoCurl = curl_getinfo($ch);

                $numIntentos++;
            }

            curl_close($ch);

            if ($infoCurl['http_code'] == 200 && $datos) {
                if(json_decode($datos) && is_file(json_decode($datos))) {
                    $datosEtiqueta = file_get_contents(json_decode($datos));
                }
                elseif(is_file($datos)) {
                    $datosEtiqueta = file_get_contents($datos);
                }
                else {
                    $datosEtiqueta = file_get_contents(__DIR__.'/../../../correosoficial/pdftmp/'.$datos);
                }
            }
        }
        else {
            try {
                $codigo = Db::getInstance()->getRow('SELECT id, shipment_code as codigo FROM `' . _DB_PREFIX_ . "correos_preregister` WHERE id_order = $pedido->id");
            }
            catch(Exception $ex) {
                try {
                    $codigo = Db::getInstance()->getRow('SELECT 0 as id, code_envio as codigo FROM `' . _DB_PREFIX_ . "correos_preregister` WHERE id_order = $pedido->id");
                }
                catch(Exception $ex) {
                    $codigo = '';
                }
            }

            $etiquetaCorreos = glob(_PS_MODULE_DIR_ . 'correos/pdftmp/' . $pedido->id . '_*.pdf');
            if ((!$etiquetaCorreos || !is_file($etiquetaCorreos[0])) && $codigo) {
                $etiquetaCorreos = glob(_PS_MODULE_DIR_ . 'correos/pdftmp/' . Tools::strtolower($codigo['codigo']) . '.pdf');
            }

            if (!$etiquetaCorreos) {
                $telefonoFalso = $this->obtenerTelefonoFalso($pedido);
                //Numero de bultos
                $bultos = $this->modulo->obtenerBultos($pedido->id);
                if(!$bultos) {
                    $bultos = $bultosManuales->obtenerBultosManuales();
                }
                if(!$bultos) {
                    $bultos = 1;
                }
                if($bultos > 1 || $telefonoFalso) {
                    require_once _PS_MODULE_DIR_ . '/correos/correos.php';
                    require_once _PS_MODULE_DIR_ . '/correos/classes/CorreosCommon.php';
                    require_once _PS_MODULE_DIR_ . '/correos/classes/CorreosAdmin.php';

                    $carrier = new Carrier((int) $pedido->id_carrier);
                    $result = CorreosCommon::getCarriers(true, '`id_reference` = ' . (int) $carrier->id_reference);
                    if ($result) {
                        $carrier_code = $result['code'];
                        $address = new Address($pedido->id_address_delivery);
                        $cart = new Cart($pedido->id_cart);
                        $correos_config = CorreosCommon::getCorreosConfiguration();

                        $correosData = CorreosAdmin::prepareData($pedido, $cart, $carrier_code, $correos_config, $address);
                        $_POST['sender'] = array(
                            'firstname' => $correosData['sender_firstname'],
                            'lastname' => $correosData['sender_lastname1'],
                            'dni' => $correosData['sender_dni'],
                            'company' => $correosData['sender_company'],
                            'contact_person' => $correosData['sender_contact_person'],
                            'address' => $correosData['sender_address'],
                            'city' => $correosData['sender_city'],
                            'state' => $correosData['sender_state'],
                            'postcode' => $correosData['sender_cp'],
                            'phone' => $correosData['sender_phone'],
                            'email' => $correosData['sender_email'],
                            'mobile' => $correosData['sender_mobile'],

                        );
                        $telefonoFalso = $this->obtenerTelefonoFalso($pedido);
                        $_POST['recipient'] = array(
                            'email' => ($telefonoFalso ? '' : $correosData['email']),
                            'mobile' => ($telefonoFalso ? $telefonoFalso : $correosData['mobile']),
                            'phone' => ($telefonoFalso ? $telefonoFalso : $correosData['phone']),
                            'mobile_lang' => $correosData['mobile_lang'],
                            'firstname' => $correosData['customer_firstname'],
                            'lastname' => $correosData['customer_lastname1'],
                            'company' => $correosData['customer_company'],
                            'address' => $correosData['delivery_address'],
                            'address2' => $correosData['delivery_address2'],
                            'city' => $correosData['delivery_city'],
                            'postcode' => ($correosData['delivery_postcode'] ? $correosData['delivery_postcode'] : $correosData['delivery_zip']),
                            'state' => $correosData['delivery_state']
                        );
                        $_POST['correos_package_weight'] = array();
                        $_POST['correos_package_long'] = array();
                        $_POST['correos_package_width'] = array();
                        $_POST['correos_package_height'] = array();
                        $_POST['correos_package_reference'] = array();
                        $_POST['correos_package_observations'] = array();
                        $peso = round($cart->getTotalWeight() / $bultos, 3);
                        for($i=0;$i<$bultos;$i++) {
                            $_POST['correos_package_weight'][] = $peso;
                            $_POST['correos_package_long'][] = ($telefonoFalso ? 10 : '');
                            $_POST['correos_package_width'][] = ($telefonoFalso ? 15 : '');
                            $_POST['correos_package_height'][] = ($telefonoFalso ? 10 : '');
                            $_POST['correos_package_reference'][] = $pedido->id;
                            $_POST['correos_package_observations'][] = '';
                            if($telefonoFalso) {
                                $_POST['goods_type'][] = $correosData['customs_description'];
                            }
                        }
                    }
                }

                $estadoCorreos = Configuration::get('CORREOS_ORDER_STATES');
                if($estadoCorreos) {
                    $estadoCorreos = json_decode(Configuration::get('CORREOS_ORDER_STATES'));
                    if($estadoCorreos) {
                        $estadoCorreos = $estadoCorreos[0];
                    }
                }
                else {
                    $estadoCorreos = Configuration::get('CORREOS_ORDER_STATE_ID');
                }
                $pedido->setCurrentState($estadoCorreos, (Validate::isLoadedObject($this->context->employee) ? $this->context->employee->id : 0));

                try {
                    $codigo = Db::getInstance()->getRow('SELECT id, shipment_code as codigo FROM `' . _DB_PREFIX_ . "correos_preregister` WHERE id_order = $pedido->id");
                }
                catch(Exception $ex) {
                    try {
                        $codigo = Db::getInstance()->getRow('SELECT 0 as id, code_envio as codigo FROM `' . _DB_PREFIX_ . "correos_preregister` WHERE id_order = $pedido->id");
                    }
                    catch(Exception $ex) {
                        $codigo = '';
                    }
                }

                $etiquetaCorreos = glob(_PS_MODULE_DIR_ . 'correos/pdftmp/' . $pedido->id . '_*.pdf');
                if ((!$etiquetaCorreos || !is_file($etiquetaCorreos[0])) && $codigo) {
                    $etiquetaCorreos = glob(_PS_MODULE_DIR_ . 'correos/pdftmp/' . Tools::strtolower($codigo['codigo']) . '.pdf');
                }
            }

            if ((!$etiquetaCorreos || !is_file($etiquetaCorreos[0])) && $codigo) {
                $token = Tools::substr(Tools::encrypt('correos/index'), 0, 10);
                $ch = curl_init('http://' . ImaxImprimePedidosServidor::getDomain() . "/modules/correos/get_label.php?order=$pedido->id&codenv={$codigo['codigo']}&id_preregister={$codigo['id']}&correos_token=$token");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
                curl_setopt($ch, CURLOPT_TIMEOUT, 360);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                $datos = curl_exec($ch);
                $infoCurl = curl_getinfo($ch);

                $numIntentos = 0;
                while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
                    curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
                    $datos = curl_exec($ch);
                    $infoCurl = curl_getinfo($ch);

                    $numIntentos++;
                }

                curl_close($ch);
            }

            $etiquetaCorreos = glob(_PS_MODULE_DIR_ . 'correos/pdftmp/' . $pedido->id . '_*.pdf');
            if ((!$etiquetaCorreos || !is_file($etiquetaCorreos[0])) && $codigo) {
                $etiquetaCorreos = glob(_PS_MODULE_DIR_ . 'correos/pdftmp/' . Tools::strtolower($codigo['codigo']) . '.pdf');
                if($etiquetaCorreos && is_file($etiquetaCorreos[0])) {
                    $datosEtiqueta = file_get_contents($etiquetaCorreos[0]);
                }
            }
        }

        return $datosEtiqueta;
    }
    
    /**
     * Reemplaza algunos caracteres que hacen fallar la generación de etiqueta.
     * @param string $texto
     * @return string
     */
    private function reemplazarCaracteres($texto) {
       return str_replace(
               ['ß', 'ẞ', 'ä', 'Ä', 'ë', 'Ë', 'ï', 'Ï', 'ö', 'Ö', 'ü', 'Ü'], 
               ['ss', 'SS', 'a', 'A', 'e', 'E', 'i', 'I', 'o', 'O', 'u', 'U'], 
               $texto);
    }
    
    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'correos';
    }
    
    /**
     * Genera la etiqueta. Hecho para usar con llamada externa.
     * @param int $id_order
     */
    public function generarEtiquetaRemoto($id_order) {
        require_once dirname(__FILE__) . '/../../../correosoficial/controllers/front/adminOrder.php';
        if(is_file(__DIR__ . '/../../../correosoficial/vendor/ecommerce_common_lib/Commons/NeedCustoms.php')) {
            require_once __DIR__ . '/../../../correosoficial/vendor/ecommerce_common_lib/Commons/NeedCustoms.php';
        }
        else {
            require_once __DIR__ . '/../../../correosoficial/ecommerce_common_lib/Commons/NeedCustoms.php';
        }
        $correos = Module::getInstanceByName('correosoficial');

        $controlador = new CorreosOficialAdminOrderModuleFrontController();
        $correos_order = CorreosOficialOrders::getCorreosOrder($id_order);
        if(!$correos_order) {
            $controlador->generateOrder('');
            
            $correos_order = CorreosOficialOrders::getCorreosOrder($id_order);
        }
        
        if($correos_order) {
            if(version_compare($correos->version, '1.5.31', '>=')) {
                require_once dirname(__FILE__) . '/../../../correosoficial/classes/CorreosOficialOrder.php';
                $correos_oficial_order = new CorreosOficialOrder($id_order);
                $shipping_number = $correos_oficial_order->getShippingNumbersByIdOrderForSavedOrder();
                $controlador->getEtiquetasByExpNumber(false, 'Correos', 'order', $shipping_number, $correos_order['shipping_number'], 2, '');
            }
            else {
                $controlador->getEtiquetasByExpNumber('order', $correos_order['shipping_number'], 2, '');
            }
        }
    }

}
