<?php
/*
 * Crea la etiqueta de Correo Ordinario.
 */
class GeneradorEtiquetaCorreoOrdinario extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        require_once dirname(__FILE__) . '/../pdf/HTMLTemplateEtiqueta.php';
        require_once dirname(__FILE__) . '/../pdf/HTMLTemplateEtiquetaOrdinario.php';
        require_once dirname(__FILE__) . '/../ImaxPDF.php';

        $plantillaCorreoOrdinario = $this->modulo->valoresPlantilla('PLANTILLA_CORREO_ORDINARIO', array('etiquetaOrdinario', '101,54'));
        
        $obj = new stdClass();
        $obj->idPedido = $pedido->id;
        $obj->plantilla = $plantillaCorreoOrdinario[0];
        $pdf = new ImaxPDF($obj, 'EtiquetaOrdinario', Context::getContext()->smarty, $this->modulo->conditionalSplit($plantillaCorreoOrdinario[1]), 'L', false, false);
        $etiqueta = $pdf->render('S');

        return $etiqueta;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'correo_ordinario';
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        $formInterno->createFormTextGroup($prefijo.'[inventarSeguimientoOrdinario]', $configuracion->inventarSeguimientoOrdinario, 
                $this->modulo->l('Agregar un seguimiento inventado ([auto])'));
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
