<?php
/*
 * Crea la etiqueta de Colissimo.
 */
class GeneradorEtiquetaColissimo extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        if (!is_file(dirname(__FILE__) . '/../../../imaxcolissimocarrier/pdf/' . $pedido->id . '.pdf')) {
            $modulo = Module::getInstanceByName('imaxcolissimocarrier');
            if ($modulo) {
                $modulo->hookActionOrderStatusPostUpdate(array('id_order' => $pedido->id), true);
            }
        }

        $datos = false;
        if (is_file(dirname(__FILE__) . '/../../../imaxcolissimocarrier/pdf/' . $pedido->id . '.pdf')) {
            $datos = file_get_contents(dirname(__FILE__) . '/../../../imaxcolissimocarrier/pdf/' . $pedido->id . '.pdf');
        }

        return $datos;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'colissimo';
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
