<?php
/*
 * Crea la etiqueta de ASM.
 */
class GeneradorEtiquetaAsm extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        try {
            if (!is_file(dirname(__FILE__) . '/../../../asmcarrier/PDF/etiqueta_' . $pedido->id . '.pdf')) {
                if (Module::isInstalled('asmcarrier')) {
                    $asm = Module::getInstanceByName('asmcarrier');
                    
                    //Numero de bultos
                    $bultos = $this->modulo->obtenerBultos($pedido->id);
                    if($bultos > 1) {
                        $_POST['asm_bultos_user'] = $bultos;
                    }

                    chdir(dirname(__FILE__) . '/../../../');
                    $asm->inicializarAsmEnvios($pedido->id);              
                    $asm->imprimirEtiquetas($pedido->id, true);
                }
            }

            if (is_file(dirname(__FILE__) . '/../../../asmcarrier/PDF/etiqueta_' . $pedido->id . '.pdf')) {
                return file_get_contents(dirname(__FILE__) . '/../../../asmcarrier/PDF/etiqueta_' . $pedido->id . '.pdf');
            }
        } catch (Exception $ex) {
            
        }

        return false;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'asm';
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
