<?php
/*
 * Crea la etiqueta de Asendia.
 */
class GeneradorEtiquetaAsendia extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        $datos = false;

        $url = 'http://' . ImaxImprimePedidosServidor::getDomain() . '/modules/imaximprimepedidosservidor/imaximprimepedidosservidor_remoto.php?accion=generarEtiquetaAsendia&passRemota='.Configuration::get(ImaxImprimePedidosServidor::prefijo . 'PASS');
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('id_order' => $pedido->id)));
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        $datosTemp = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);

        $numIntentos = 0;
        while (($infoCurl['http_code'] == 301 || $infoCurl['http_code'] == 302) && $numIntentos < 10) {
            curl_setopt($ch, CURLOPT_URL, $infoCurl['redirect_url']);
            $datosTemp = curl_exec($ch);
            $infoCurl = curl_getinfo($ch);

            $numIntentos++;
        }

        curl_close($ch);		

        if ($datosTemp) {
            $datos = $datosTemp;
        }

        return $datos;
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'asendia';
    }
    
    /**
     * Genera la etiqueta. Hecho para usar con llamada externa.
     */
    public function generarEtiquetaRemoto() {
        $psAdminDir = Configuration::getGlobalValue(ImaxImprimePedidosServidor::prefijo . 'ADMIN');
        if(!defined('_PS_ADMIN_DIR_')) {
            define('_PS_ADMIN_DIR_', $psAdminDir);
            define('_PS_BO_ALL_THEMES_DIR_', _PS_ADMIN_DIR_.'/themes/');
        }
        
        require_once dirname(__FILE__) . '/../../../soapasendia/controllers/admin/AdminSoapasendiaController.php';
        
        $sql = 'SELECT id_employee FROM ' . _DB_PREFIX_ . 'employee WHERE id_profile=1 AND active=1';
        $idEmployee = Db::getInstance()->getValue($sql);
        Context::getContext()->employee = new Employee($idEmployee);
		Cache::store('isLoggedBack' . $idEmployee, true);
        $controlador = new AdminSoapasendiaController();
        $controlador->initContent();
    }
    
    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        $nombre = ucfirst(str_replace('_', ' ', $this->obtenerId()));
        
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormCheckboxGroupList($prefijo.'[idsReference]', $this->modulo->l("Selecciona los transportistas de $nombre:"), 
                $this->modulo->l("Selecciona los transportistas de $nombre:"), $transportistasAdaptados, $configuracion->idsReference);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l("Estado de los pedidos de $nombre despues de generar la etiqueta:"), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        
        return $acordeon->renderAcordeon($nombre, $formInterno->renderForm(true), true);
    }
}
