<?php
namespace clases\accesoDatos;

/**
 * Filtro de lectura para PHPExcel que permite saltarse lineas e indicar la cantidad a leer.
 */
class ChunkReadFilter implements \PHPExcel_Reader_IReadFilter {

    private $_startRow = 1;
    private $_endRow = 1;

    /**
     * Indica la primera linea a leer y la cantidad de ellas.
     * @param int $startRow
     * @param int $chunkSize
     */
    public function setRows($startRow, $chunkSize) {
        $this->_startRow = $startRow + 1;
        $this->_endRow = $startRow + $chunkSize + 1;
    }

    public function readCell($column, $row, $worksheetName = '') {
        if ($row >= $this->_startRow && $row < $this->_endRow) {
            return true;
        }
        
        return false;
    }
}
