<?php
namespace clases\accesoDatos;

/**
 * Obtiene datos de un archivo CSV.
 */
class AccesoDatosCSV implements iAccesoDatos {
    private $fh, $separadorCampos, $separadorTexto, $caracterEscape;
    
    /**
     * 
     * @param string $archivo
     * @param int $posicionActual
     * @param int $numLineasCabecera
     * @param string $separadorCampos
     * @param string $separadorTexto
     * @param string $caracterEscape
     */
    function __construct($archivo, $posicionActual, $numLineasCabecera = 1, $separadorCampos = ',', $separadorTexto = '"', $caracterEscape = '\\') {
        if(is_file($archivo)) {
            $this->fh = fopen($archivo, 'r');
        }

        $this->separadorCampos = $separadorCampos;
        $this->separadorTexto = $separadorTexto;
        $this->caracterEscape = $caracterEscape;

        $this->saltarLineas($posicionActual, $numLineasCabecera);
    }

    public function obtenerFila() {
        return fgetcsv($this->fh, 0, $this->separadorCampos, $this->separadorTexto, $this->caracterEscape);
    }
    
    /**
     * Avanza el puntero en el archivo CSV.
     * @param int $posicionActual La linea a procesar.
     * @param int $numLineasCabecera 
     */
    private function saltarLineas($posicionActual, $numLineasCabecera) {
        if (!$posicionActual) {
            $posicionActual = $numLineasCabecera;
        }
        
        for ($i = 0; $i < $posicionActual; $i++) {
            fgetcsv($this->fh, 0, $this->separadorCampos, $this->separadorTexto, $this->caracterEscape);
        }
    }
    
    /**
     * Cierra el fichero.
     */
    public function cerrarArchivo() {
        if($this->fh) {
            fclose($this->fh);
        }
    }
}
