<?php

class IntermediarioDeluxeTracking {
    /**
     * Devuelve el lote indicado.
     * @param string $lote
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad 0 para cargar todas.
     * @param int $estado
     * @return array
     */
    public function cargarLote($lote, $id_product, $id_product_attribute, $cantidad, $estado = ConectorDeluxeTracking::ESTADO_DISPONIBLE) {
        $lote = pSQL($lote);
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $cantidad = (int)$cantidad;
        $estado = (int)$estado;

        return Db::getInstance()->executeS('
            SELECT * FROM `'._DB_PREFIX_."idxrtracking` 
                WHERE out_lot = '$lote' AND id_product = '$id_product' AND id_attribute = '$id_product_attribute' AND id_status = $estado
            ORDER BY date_expiry ASC, id_tracking ASC".
            ($cantidad ? " LIMIT $cantidad" : ''));
    }
    
    /**
     * Devuelve el lote que se deberia utilizar a continuacion para el producto indicado.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return string
     */
    public function loteSiguiente($id_product, $id_product_attribute) {
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        
        return Db::getInstance()->getValue('
            SELECT out_lot FROM `'._DB_PREFIX_."idxrtracking` 
                WHERE id_product = '$id_product' AND id_attribute = '$id_product_attribute' AND id_status = 1 AND out_lot != '' 
                    AND out_lot != '0' AND out_lot != '1' AND out_lot != '2' AND out_lot != '3' AND out_lot != '4' AND out_lot != '---' 
                    AND out_lot != '----'
            ORDER BY date_expiry ASC, id_tracking ASC");
    }
    
    /**
     * Modifica el estado de uno o mas lineas.
     * @param string $lote
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad 0 para cambiar todas.
     * @param int $estado
     * @param int $id_order Modifica el id de pedido de la linea.
     * @param int $estadoActual 
     * @param string $nombreProducto 
     * @param int $fechaFactura 
     * @param string $invoice_number 
     * @return boolean
     */
    public function modificarEstado($lote, $id_product, $id_product_attribute, $cantidad, $estado, $id_order = false, 
            $estadoActual = ConectorDeluxeTracking::ESTADO_DISPONIBLE, $nombreProducto = false, $fechaFactura = false, $invoice_number = false) {
        $lote = pSQL($lote);
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $cantidad = (int)$cantidad;
        $estado = (int)$estado;
        if($id_order !== false) {
            $id_order = (int)$id_order;
            $id_order_string = ", id_order = '$id_order'";
        }
        else {
            $id_order_string = '';
        }
        $estadoActual = (int)$estadoActual;
        if($nombreProducto !== false) {
            $nombreProducto = pSQL($nombreProducto);
            $nombreProductoString = ", product_sold = '$nombreProducto'";
        }
        else {
            $nombreProductoString = '';
        }
        if($fechaFactura !== false) {
            $fechaFactura = (int)$fechaFactura;
            $fechaFacturaString = ", date_out_invoice = $fechaFactura";
        }
        else {
            $fechaFacturaString = '';
        }
        if($invoice_number !== false) {
            $invoice_number = pSQL($invoice_number);
            $numeroFacturaString = ", out_invoice = '$invoice_number'";
        }
        else {
            $numeroFacturaString = '';
        }

        return Db::getInstance()->execute('
            UPDATE `'._DB_PREFIX_."idxrtracking` SET id_status = '$estado' $id_order_string $nombreProductoString $fechaFacturaString $numeroFacturaString
                WHERE out_lot = '$lote' AND id_product = '$id_product' AND id_attribute = '$id_product_attribute' AND id_status = '$estadoActual'
            ORDER BY date_expiry ASC, id_tracking ASC".
            ($cantidad ? " LIMIT $cantidad" : ''));
    }
    
    /**
     * Cambia a disponible unas lineas.
     * @param string $lote
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $cantidad
     * @param int $id_order
     * @return boolean
     */
    public function marcarDisponible($lote, $id_product, $id_product_attribute, $cantidad, $id_order) {
        $lote = pSQL($lote);
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;
        $cantidad = (int)$cantidad;
        $id_order = (int)$id_order;
        $estado = ConectorDeluxeTracking::ESTADO_DISPONIBLE;
        $estadoActual = ConectorDeluxeTracking::ESTADO_EN_PEDIDO;

        return Db::getInstance()->execute('
            UPDATE `'._DB_PREFIX_."idxrtracking` SET id_status = '$estado', id_order = 0, date_out_invoice = '', out_invoice = ''
                WHERE out_lot = '$lote' AND id_product = '$id_product' AND id_attribute = '$id_product_attribute' AND id_status = '$estadoActual'
                    AND id_order = '$id_order'
            ORDER BY date_expiry DESC, id_tracking DESC".
            ($cantidad ? " LIMIT $cantidad" : ''));
    }
    
    /**
     * Modifica el estado de las lineas de un pedido.
     * @param int $id_order
     * @param int $estado
     * @param string $out_invoice Tambien asigna la fecha.
     * @param int $nuevo_id_order
     * @return boolean
     */
    public function modificarEstadoPorPedido($id_order, $estado, $out_invoice = false, $nuevo_id_order = false) {
        $id_order = (int)$id_order;
        $estado = (int)$estado;
        $extra = '';
        if($out_invoice !== false) {
            $fechaFactura = pSQL(date('Y-m-d H:i:s'));
            $out_invoice = pSQL($out_invoice);
            $extra .= ", out_invoice = '$out_invoice', date_out_invoice = '$fechaFactura'";
        }
        if($nuevo_id_order !== false) {
            $extra .= ', id_order = '.(int)$nuevo_id_order;
        }
        
        return Db::getInstance()->execute('
            UPDATE `'._DB_PREFIX_."idxrtracking` SET id_status = '$estado' $extra
                WHERE id_order = '$id_order'");
    }
    
    /**
     * Devuelve las lineas que estan reservadas para un pedido.
     * @param int $id_order
     * @return array
     */
    public function cargarReservados($id_order) {
        $id_order = (int)$id_order;
        $enPedido = ConectorDeluxeTracking::ESTADO_EN_PEDIDO;
        $vendido = ConectorDeluxeTracking::ESTADO_VENDIDO;
        
        return Db::getInstance()->executeS('
            SELECT * FROM `'._DB_PREFIX_."idxrtracking` WHERE id_order = '$id_order' AND id_status IN ('$enPedido', '$vendido') 
                ORDER BY date_expiry ASC");
    }
    
    /**
     * Indica si un producto aparece en la tabla de lotes.
     * @param int $id_product
     * @param int $id_product_attribute
     * @return boolean
     */
    public function usaLotes($id_product, $id_product_attribute) {
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;

        return (boolean)Db::getInstance()->getValue('
            SELECT 1 FROM `'._DB_PREFIX_."idxrtracking` 
                WHERE id_product = '$id_product' AND id_attribute = '$id_product_attribute' AND out_lot != '' 
                    AND out_lot != '0' AND out_lot != '1' AND out_lot != '2' AND out_lot != '3' AND out_lot != '4' AND out_lot != '---' 
                    AND out_lot != '----'");
    }
    
    /**
     * Indica si un lote existe.
     * @param string $lote
     * @param int $id_product
     * @param int $id_product_attribute
     * @return boolean
     */
    public function esLote($lote, $id_product, $id_product_attribute) {
        $lote = pSQL($lote);
        $id_product = (int)$id_product;
        $id_product_attribute = (int)$id_product_attribute;

        return (boolean)Db::getInstance()->getValue('
            SELECT 1 FROM `'._DB_PREFIX_."idxrtracking` 
                WHERE out_lot = '$lote' AND id_product = '$id_product' AND id_attribute = '$id_product_attribute'");
    }
}
