<?php

class ImaxPDFGenerator extends PDFGeneratorCore {
    private $useHeader, $useFooter;

    /**
     * Para generar pdfs.
     * @param string $size
     * @param string $orientation
     * @param boolean $use_cache
     * @param boolean $useHeader
     * @param boolean $useFooter
     */
    public function __construct($size = 'A4', $orientation = 'P', $use_cache = false, $useHeader = true, $useFooter = true) {
        TCPDF::__construct($orientation, 'mm', $size, true, 'UTF-8', $use_cache, false);
        
        $this->useHeader = $useHeader;
        $this->useFooter = $useFooter;
    }
    
    public function Header() {
        if($this->useHeader) {
            $this->writeHTML($this->header);
        }
    }

    public function Footer() {
        if($this->useFooter) {
            $this->writeHTML($this->footer);
        }
    }
    
    public function writePage() {
        if($this->useHeader) {
            $marginTop = 45;
        }
        else {
            $marginTop = 5;
        }
        
        if($this->useFooter) {
            $marginBotton = 12;
        }
        else {
            $marginBotton = 5;
        }
        
        if(!$this->useHeader && !$this->useFooter) {
            $marginTop = 1;
            $marginBotton = -2;
            $restoMargenes = 1;
        }
        else {
            $restoMargenes = 5;
        }
        
        $this->SetHeaderMargin($restoMargenes);
        $this->SetFooterMargin($marginBotton);
        $this->setMargins($restoMargenes, $marginTop, $restoMargenes);
        $this->SetAutoPageBreak(true, $marginBotton + 3);
        $this->AddPage();
        $this->writeHTML($this->content, true, false, true, false, '');
        if($this->getBarcode()) {
            $this->write1DBarcode($this->getBarcode(), 'C128', '', '', '', '', '0.6', array('position' => 'C'));
        }
    }
}
