<?php
require_once dirname(__FILE__) . '/ImaxPDFGenerator.php';

class ImaxPDF extends PDFCore {

    /**
     * Clase para generar pdfs.
     * @param Iterator $objects
     * @param string $template
     * @param Smarty $smarty
     * @param string $size
     * @param string $orientation
     * @param boolean $useHeader
     * @param boolean $useFooter
     */
    public function __construct($objects, $template, $smarty, $size = 'A4', $orientation = 'P', $useHeader = true, $useFooter = true) {
        parent::__construct($objects, $template, $smarty, $orientation);
        $this->pdf_renderer = new ImaxPDFGenerator($size, $orientation, (bool) Configuration::get('PS_PDF_USE_CACHE'), $useHeader, $useFooter);
        $this->template = $template;
        
        $this->smarty = clone $smarty;
        $this->smarty->escape_html = false;

        $this->objects = $objects;
        if (!($objects instanceof Iterator) && !is_array($objects)) {
            $this->objects = array($objects);
        }
        
        if(version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
            //Funciones que faltan en 1.7
            $original_lazy_register = SmartyLazyRegister::getInstance($this->smarty);
            smartyRegisterFunction($this->smarty, 'function', 'convertPrice', array('Product', 'convertPrice'), true, $original_lazy_register);
            smartyRegisterFunction($this->smarty, 'function', 'convertPriceWithCurrency', array('Product', 'convertPriceWithCurrency'), true, $original_lazy_register);
            smartyRegisterFunction($this->smarty, 'function', 'displayWtPrice', array('Product', 'displayWtPrice'), true, $original_lazy_register);
            smartyRegisterFunction($this->smarty, 'function', 'displayWtPriceWithCurrency', array('Product', 'displayWtPriceWithCurrency'), true, $original_lazy_register);
            smartyRegisterFunction($this->smarty, 'function', 'displayPrice', array('Tools', 'displayPriceSmarty'), true, $original_lazy_register);
            smartyRegisterFunction($this->smarty, 'modifier', 'convertAndFormatPrice', array('Product', 'convertAndFormatPrice'), true, $original_lazy_register); // used twice
            smartyRegisterFunction($this->smarty, 'function', 'displayAddressDetail', array('AddressFormat', 'generateAddressSmarty'), true, $original_lazy_register);
            smartyRegisterFunction($this->smarty, 'function', 'getWidthSize', array('Image', 'getWidth'), true, $original_lazy_register);
            smartyRegisterFunction($this->smarty, 'function', 'getHeightSize', array('Image', 'getHeight'), true, $original_lazy_register);
        }
    }
}
