<?php
/**
 * Devuelve la etiqueta generica.
 */
class GeneradorEtiquetaGenerica extends GeneradorEtiqueta {

    /**
     * {@inheritDoc}
     */
    protected function generarEtiquetaInterno($pedido, $bultosManuales) {
        require_once dirname(__FILE__) . '/pdf/HTMLTemplateEtiqueta.php';
        require_once dirname(__FILE__) . '/ImaxPDF.php';
        
        $plantillaGenerica = $this->modulo->valoresPlantilla('PLANTILLA_GENERICA', array('etiqueta', 'A5'));
        $configuracion = $this->cargarConfiguracion();
        $mostrarNumeroBultos = $configuracion->bultosManuales;

        $obj = new stdClass();
        $obj->idPedido = $pedido->id;
        $obj->plantilla = $plantillaGenerica[0];
        $obj->numBultos = ($mostrarNumeroBultos ? $bultosManuales->obtenerBultosManuales() : 0);
        $pdf = new ImaxPDF($obj, 'Etiqueta', Context::getContext()->smarty, $this->modulo->conditionalSplit($plantillaGenerica[1]), 'L', false, false);
        $etiqueta = $pdf->render('S');

        return $etiqueta;
    }

    /**
     * {@inheritDoc}
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $configuracion = $this->cargarConfiguracion();
        $prefijo = 'datosTransportista['.$this->obtenerId().']';
        
        $acordeonGenerico = new imaxAcordeon($this->modulo->getPathUri());
        $formInterno = new imaxForm($this->modulo, $this->modulo->getPathUri(), '', '', '', '', false, true);
        $formInterno->createFormSelect($prefijo.'[nuevoEstado]', $this->modulo->l('Estado de los demas pedidos despues de generar la etiqueta:'), 
                $estadosAdaptados, $configuracion->nuevoEstado);
        $formInterno->createFormCheckboxGroup($prefijo.'[bultosManuales]', $this->modulo->l('Numero de bultos manual'), 
                $configuracion->bultosManuales);
        return $acordeonGenerico->renderAcordeon($this->modulo->l('Resto'), $formInterno->renderForm(true), true);
    }

    /**
     * {@inheritDoc}
     */
    public function obtenerId() {
        return 'generica';
    }
}
