<?php

class CentralizadorEtiquetas {
    private $modulo;
    private static $generadores = [];
    
    /**
     * 
     * @param ImaxImprimePedidosServidor $modulo
     */
    public function __construct($modulo) {
        $this->modulo = $modulo;
    }
    
    /**
     * Devuelve el generador a utilizar para el transportista.
     * @param int $id_reference
     * @return GeneradorEtiqueta
     */
    public function obtenerGenerador($id_reference) {
        $generadores = $this->cargarGeneradoresEtiqueta();
        $resultado = new GeneradorEtiquetaGenerica($this->modulo);
        foreach($generadores as $generador) {
            $configuracion = $generador->cargarConfiguracion();
            if(in_array($id_reference, $configuracion->idsReference)) {
                $resultado = $generador;
                break;
            }
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve instancias de todos los generadores de etiqueta.
     * @return GeneradorEtiqueta
     */
    private function cargarGeneradoresEtiqueta() {
        if(!self::$generadores) {
            $dir = dir(__DIR__.'/generadoresEtiqueta');
            while(($archivo = $dir->read()) !== false) {
                if(stripos($archivo, '.php') !== false && stripos($archivo, '.imax') === false) {
                    require_once __DIR__.'/generadoresEtiqueta/'.basename($archivo);

                    $nombreClase = basename($archivo, ".php");
                    self::$generadores[] = new $nombreClase($this->modulo);
                }
            }
            usort(self::$generadores, function($a, $b) {
                return strcasecmp($a->obtenerId(), $b->obtenerId());
            });
            require_once __DIR__.'/GeneradorEtiquetaGenerica.php';
            self::$generadores[] = new GeneradorEtiquetaGenerica($this->modulo);
        }
        
        return self::$generadores;
    }
    
    /**
     * Guarda la configuración.
     * @param array $post
     * @return bool
     */
    public function grabarConfiguracion($post) {
        $resultado = true;
        
        $generadores = $this->cargarGeneradoresEtiqueta();
        foreach($generadores as $generador) {
            if(!$generador->grabarConfiguracion($post)) {
                $resultado = false;
            }
        }
        
        return $resultado;
    }
    
    /**
     * Devuelve el html de la configuración.
     * @param array $transportistasAdaptados
     * @param array $estadosAdaptados
     * @return string
     */
    public function generarVisualizacion($transportistasAdaptados, $estadosAdaptados) {
        $htmlInterno = '';
        $acordeon = new imaxAcordeon($this->modulo->getPathUri());
        $form = new imaxForm($this->modulo, $this->modulo->getPathUri());
        $form->createHidden("action", "configurar");
        $form->createHidden("idTab", "3");
        
        $generadores = $this->cargarGeneradoresEtiqueta();
        foreach($generadores as $generador) {
            $htmlInterno .= $generador->generarVisualizacion($transportistasAdaptados, $estadosAdaptados);
        }
        
        $form->addToForm($htmlInterno);
        $form->createSubmitButton('opcionesConfiguracion', $this->modulo->l('Guardar'));
        return $acordeon->renderAcordeon($this->modulo->l('Configuracion Transporte'), $form->renderForm());
    }
    
    /**
     * Guarda en el lugar correspondiente el numero de bultos de un pedido.
     * @param int $id_order
     * @param int $bultos
     * @return boolean
     */
    public function insertarBultosManuales($id_order, $bultos) {
        $pedido = new Order($id_order);
        $referenciasTransportista = $this->modulo->obtenerReferenciaTransportistas();
        //Grabamos los bultos en el módulo imaxgls de ser necesario
        $imaxGls = Module::getInstanceByName('imaxgls');
        if($imaxGls) {
            $gls = unserialize(Configuration::getGlobalValue(ImaxGls::PREFIJO . '_TRANSPORTISTAS'));
            $dhl = unserialize(Configuration::getGlobalValue(ImaxGls::PREFIJO . '_TRANSPORTISTAS_DHL'));
            $imaxGlsManual = Configuration::getGlobalValue(ImaxGls::PREFIJO . '_BULTOS_MANUAL');
            if($imaxGlsManual && (($gls && in_array($referenciasTransportista[$pedido->id_carrier], $gls)) || 
                    ($dhl && in_array($referenciasTransportista[$pedido->id_carrier], $dhl)))) {
                if(method_exists($imaxGls, 'cargarInfoBultos')) {
                    $imaxGls->hookActionOrderStatusUpdate(['id_order' => $pedido->id], true);
                    $imaxGls->actualizarBultos($pedido->id, $bultos);
                }
            }
        }

        //Grabamos los bultos de ser necesario
        $id_reference = (isset($referenciasTransportista[$pedido->id_carrier]) ? $referenciasTransportista[$pedido->id_carrier] : 0);
        $generador = $this->obtenerGenerador($id_reference);
        if($generador->cargarConfiguracion()->bultosManuales) {
            $bultosManuales = new BultosManuales($id_order);
            $bultosManuales->grabarBultosManuales($bultos);
        }

        return true;
    }
}
