<?php
/**
 * Clase para manejar la cantidad de bultos de un pedido.
 */
class BultosManuales {
    private $id_order;
    
    /**
     * 
     * @param int $id_order
     */
    public function __construct($id_order) {
        $this->id_order = (int)$id_order;
    }

    /**
     * Marca como descargados los bultos.
     * @return boolean
     */
    public function marcarBultosManualesDescargados() {
        return Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."numBultos` (id_order, descargado) 
            VALUES ('$this->id_order', '1') ON DUPLICATE KEY UPDATE descargado = '1'");
    }
    
    /**
     * Graba el numero de bultos.
     * @param int $bultos
     * @return boolean
     */
    public function grabarBultosManuales($bultos) {
        $bultos = (int)$bultos;
        if(!$bultos) {
            $bultos = 1;
        }
        return Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."numBultos` (id_order, bultos) 
            VALUES ('$this->id_order', '$bultos') ON DUPLICATE KEY UPDATE bultos = '$bultos'");
    }
    
    /**
     * Devuelve el numero de bultos para el pedido.
     * @return int
     */
    public function obtenerBultosManuales() {
        return (int)Db::getInstance()->getValue('SELECT bultos FROM `'._DB_PREFIX_.ImaxImprimePedidosServidor::prefijo."numBultos` 
            WHERE id_order = '$this->id_order'");
    }
    
    /**
     * Devuelve los datos almacenados sobre los bultos manuales del pedido.
     * @param int $id_order
     * @return array
     */
    public function obtenerDatosBultosManuales() {
        return Db::getInstance()->getRow('SELECT bultos, descargado FROM `' . _DB_PREFIX_ . ImaxImprimePedidosServidor::prefijo . "numBultos` 
            WHERE id_order = '$this->id_order'");
    }
}
