<?php

use PrestaShop\PrestaShop\Adapter\ServiceLocator;

class StockAvailable extends StockAvailableCore
{

/**
     * For a given id_product and id_product_attribute sets the quantity available.
     *
     * @param $id_product
     * @param $id_product_attribute
     * @param $quantity
     * @param null $id_shop
     * @param bool $add_movement
     *
     * @return bool
     */
    public static function setQuantity($id_product, $id_product_attribute, $quantity, $id_shop = null, $add_movement = true)
    {
        if (!Validate::isUnsignedId($id_product)) {
            return false;
        }
        $context = Context::getContext();
        // if there is no $id_shop, gets the context one
        if ($id_shop === null && Shop::getContext() != Shop::CONTEXT_GROUP) {
            $id_shop = (int) $context->shop->id;
        }
        $depends_on_stock = StockAvailable::dependsOnStock($id_product);
        //Try to set available quantity if product does not depend on physical stock
        if (!$depends_on_stock) {
            $stockManager = ServiceLocator::get('\\PrestaShop\\PrestaShop\\Core\\Stock\\StockManager');

            $id_stock_available = (int) StockAvailable::getStockAvailableIdByProductId($id_product, $id_product_attribute, $id_shop);
            if ($id_stock_available) {
                $stock_available = new StockAvailable($id_stock_available);

                $deltaQuantity = (int) $quantity - (int) $stock_available->quantity;

                $stock_available->quantity = (int) $quantity;
                $stock_available->update();

                if (true === $add_movement && 0 != $deltaQuantity) {
                    $stockManager->saveMovement($id_product, $id_product_attribute, $deltaQuantity);
                }
            } else {
                $out_of_stock = StockAvailable::outOfStock($id_product, $id_shop);
                $stock_available = new StockAvailable();
                $stock_available->out_of_stock = (int) $out_of_stock;
                $stock_available->id_product = (int) $id_product;
                $stock_available->id_product_attribute = (int) $id_product_attribute;
                $stock_available->quantity = (int) $quantity;
                if ($id_shop === null) {
                    $shop_group = Shop::getContextShopGroup();
                } else {
                    $shop_group = new ShopGroup((int) Shop::getGroupFromShop((int) $id_shop));
                }
                // if quantities are shared between shops of the group
                if ($shop_group->share_stock) {
                    $stock_available->id_shop = 0;
                    $stock_available->id_shop_group = (int) $shop_group->id;
                } else {
                    $stock_available->id_shop = (int) $id_shop;
                    $stock_available->id_shop_group = 0;
                }
                $stock_available->add();

                if (true === $add_movement && 0 != $quantity) {
                    $stockManager->saveMovement($id_product, $id_product_attribute, (int) $quantity);
                }
            }

            Hook::exec(
                'actionUpdateQuantity',
                [
                    'id_product' => $id_product,
                    'id_product_attribute' => $id_product_attribute,
                    'quantity' => $stock_available->quantity,
                ]
            );

            //Aquí

              $sql = 'SELECT * FROM '._DB_PREFIX_.'stock_available_advanced WHERE id_product="'.$id_product.'" and id_product_attribute="'.$id_product_attribute.'" order by date_add DESC';
              $comments="Establecida de forma Manual";

              

               if($row = Db::getInstance()->getRow($sql)){

                    $reserved_quantity=$row['reserved_quantity'];
                    $stock_available->quantity=$stock_available->quantity - $row['reserved_quantity'];
                    $stock_available->update();
                    $physical_quantity=$stock_available->quantity + $row['reserved_quantity'];
                    $mvt_physical=$physical_quantity - $row['stock_quantity'];
                }
                else{
                     $mvt_physical=$stock_available->quantity;
                     $reserved_quantity=0;
                     $physical_quantity=$stock_available->quantity;
                 }
               $date_add= date('Y-m-d H:i:s');
               $id_stock_mvt_reason="Edición de Producto";
               $sign=-1;
               if($mvt_physical>0)
                    $sign=1;
               
               $mvt_reserved=0;

               $id_order=0;
               $id_order_status=0;
               $id_employee = Context::getContext()->employee->id;



            $lang_id = Context::getContext()->language->id;
            $productT = new Product($id_product, false, $lang_id);
            $product_name=$productT->name;
            $reference=$productT->reference;

            if($id_product_attribute>0)
            {
                //Obtener Referencia
                $reference=StockAvailable::getReferenceAtributo($id_product,$id_product_attribute);
                $product_name=$product_name. " - ". StockAvailable::getNameAtributo($id_product_attribute);

            }


   

                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'","'.$id_product_attribute.'","'.$id_order.'","'.$id_order_status.'","'.$stock_available->quantity.'","'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'","'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'","'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';

                                 

                    Db::getInstance()->execute($sql);



            //
        }
        Cache::clean('StockAvailable::getQuantityAvailableByProduct_' . (int) $id_product . '*');
    }

    public function getReferenceAtributo($id_product,$id_product_attribute)
    {
        $sql = 'SELECT  reference ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'product_attribute p ';
        $sql .= 'WHERE p.id_product_attribute=' . $id_product_attribute . ' and p.id_product=' . $id_product .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['reference'];
        }
        else
            return "";

    }

    public function getNameAtributo($id_product_attribute)
    {
        //lang
        $id_lang=Context::getContext()->language->id;
        $sql = 'SELECT  name ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'attribute_lang a ';
        $sql .= 'WHERE a.id_attribute=' . $id_product_attribute . ' and a.id_lang=' . $id_lang .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['name'];
        }
        else
            return "";

    }

    public function insertInventario($reference,$quantity,$comments,$fila)
    {
        $id_product="";
        $id_shop = null; $add_movement = true;
        $sql = 'SELECT  id_product,id_product_attribute ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'product_attribute p ';
        $sql .= 'WHERE p.reference="' . $reference . '" ';
        if($row = Db::getInstance()->getRow($sql))
        {
            $id_product=$row['id_product'];
            $id_product_attribute=$row['id_product_attribute'];
        }
        else
        {
            $sql = 'SELECT  id_product ';
            $sql .= 'FROM ' . _DB_PREFIX_ . 'product p ';
            $sql .= 'WHERE p.reference="' . $reference . '" ';
            if($row = Db::getInstance()->getRow($sql))
            {
                $id_product=$row['id_product'];
                $id_product_attribute=0;
            }

        }


            
        if($id_product!=""){
       
        



         if (!Validate::isUnsignedId($id_product)) {
            return false;
        }
        $context = Context::getContext();
        // if there is no $id_shop, gets the context one
        if ($id_shop === null && Shop::getContext() != Shop::CONTEXT_GROUP) {
            $id_shop = (int) $context->shop->id;
        }
        $depends_on_stock = StockAvailable::dependsOnStock($id_product);
        //Try to set available quantity if product does not depend on physical stock
        if (!$depends_on_stock) {
            $stockManager = ServiceLocator::get('\\PrestaShop\\PrestaShop\\Core\\Stock\\StockManager');

            $id_stock_available = (int) StockAvailable::getStockAvailableIdByProductId($id_product, $id_product_attribute, $id_shop);
            if ($id_stock_available) {
                $stock_available = new StockAvailable($id_stock_available);

                $deltaQuantity = (int) $quantity - (int) $stock_available->quantity;

                $stock_available->quantity = (int) $quantity;
                $stock_available->update();

                if (true === $add_movement && 0 != $deltaQuantity) {
                    $stockManager->saveMovement($id_product, $id_product_attribute, $deltaQuantity);
                }
            } else {
                $out_of_stock = StockAvailable::outOfStock($id_product, $id_shop);
                $stock_available = new StockAvailable();
                $stock_available->out_of_stock = (int) $out_of_stock;
                $stock_available->id_product = (int) $id_product;
                $stock_available->id_product_attribute = (int) $id_product_attribute;
                $stock_available->quantity = (int) $quantity;
                if ($id_shop === null) {
                    $shop_group = Shop::getContextShopGroup();
                } else {
                    $shop_group = new ShopGroup((int) Shop::getGroupFromShop((int) $id_shop));
                }
                // if quantities are shared between shops of the group
                if ($shop_group->share_stock) {
                    $stock_available->id_shop = 0;
                    $stock_available->id_shop_group = (int) $shop_group->id;
                } else {
                    $stock_available->id_shop = (int) $id_shop;
                    $stock_available->id_shop_group = 0;
                }
                $stock_available->add();

                if (true === $add_movement && 0 != $quantity) {
                    $stockManager->saveMovement($id_product, $id_product_attribute, (int) $quantity);
                }
            }

            Hook::exec(
                'actionUpdateQuantity',
                [
                    'id_product' => $id_product,
                    'id_product_attribute' => $id_product_attribute,
                    'quantity' => $stock_available->quantity,
                ]
            );

            //Aquí

              $sql = 'SELECT * FROM '._DB_PREFIX_.'stock_available_advanced WHERE id_product="'.$id_product.'" and id_product_attribute="'.$id_product_attribute.'" order by date_add DESC';
              $comments=$comments;

              

               if($row = Db::getInstance()->getRow($sql)){

                    $reserved_quantity=$row['reserved_quantity'];
                    $stock_available->quantity=$stock_available->quantity - $row['reserved_quantity'];
                    $stock_available->update();
                    $physical_quantity=$stock_available->quantity + $row['reserved_quantity'];
                    $mvt_physical=$physical_quantity - $row['stock_quantity'];
                }
                else{
                     $mvt_physical=$stock_available->quantity;
                     $reserved_quantity=0;
                     $physical_quantity=$stock_available->quantity;
                 }
               $date_add= date('Y-m-d H:i:s');
               $id_stock_mvt_reason="Edición de Producto";
               $sign=-1;
               if($mvt_physical>0)
                    $sign=1;
               
               $mvt_reserved=0;

               $id_order=0;
               $id_order_status=0;
               $id_employee = Context::getContext()->employee->id;



            $lang_id = Context::getContext()->language->id;
            $productT = new Product($id_product, false, $lang_id);
            $product_name=$productT->name;
            $reference=$productT->reference;

            if($id_product_attribute>0)
            {
                //Obtener Referencia
                $reference=StockAvailable::getReferenceAtributo($id_product,$id_product_attribute);
                $product_name=$product_name. " - ". StockAvailable::getNameAtributo($id_product_attribute);

            }


   

                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'","'.$id_product_attribute.'","'.$id_order.'","'.$id_order_status.'","'.$stock_available->quantity.'","'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'","'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'","'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';

                                 

                    Db::getInstance()->execute($sql);



            //
        }
        Cache::clean('StockAvailable::getQuantityAvailableByProduct_' . (int) $id_product . '*');
        $ok[0]="Ok";
        $ok[1]="Fila ".$fila;
        $ok[2]="Importado Correctamente";
        return $ok;
    }
    else
    {
        $error[0]="Error";
        $error[1]="Fila ".$fila;
        $error[2]="No existe Referencia";
        return $error;
    }
    }


}