<?php


use PrestaShop\PrestaShop\Adapter\MailTemplate\MailPartialTemplateRenderer;
use PrestaShop\PrestaShop\Adapter\StockManager as StockManagerAdapter;
use PrestaShop\PrestaShop\Core\Stock\StockManager;

class OrderHistory extends OrderHistoryCore{



/**
     * Sets the new state of the given order.
     *
     * @param int $new_order_state
     * @param int/object $id_order
     * @param bool $use_existing_payment
     */
    public function changeIdOrderState($new_order_state, $id_order, $use_existing_payment = false)
    {
        if (!$new_order_state || !$id_order) {
            return;
        }

        if (!is_object($id_order) && is_numeric($id_order)) {
            $order = new Order((int) $id_order);
        } elseif (is_object($id_order)) {
            $order = $id_order;
        } else {
            return;
        }

        ShopUrl::cacheMainDomainForShop($order->id_shop);

        $new_os = new OrderState((int) $new_order_state, $order->id_lang);
        $old_os = $order->getCurrentOrderState();

        // executes hook
        if (in_array($new_os->id, [Configuration::get('PS_OS_PAYMENT'), Configuration::get('PS_OS_WS_PAYMENT')])) {
            Hook::exec('actionPaymentConfirmation', ['id_order' => (int) $order->id], null, false, true, false, $order->id_shop);
        }

        // executes hook
        Hook::exec('actionOrderStatusUpdate', ['newOrderStatus' => $new_os, 'id_order' => (int) $order->id], null, false, true, false, $order->id_shop);

        if (Validate::isLoadedObject($order) && ($new_os instanceof OrderState)) {
            $context = Context::getContext();

            // An email is sent the first time a virtual item is validated
            $virtual_products = $order->getVirtualProducts();
            if ($virtual_products && (!$old_os || !$old_os->logable) && $new_os && $new_os->logable) {
                $assign = [];
                foreach ($virtual_products as $key => $virtual_product) {
                    $id_product_download = ProductDownload::getIdFromIdProduct($virtual_product['product_id']);
                    $product_download = new ProductDownload($id_product_download);
                    // If this virtual item has an associated file, we'll provide the link to download the file in the email
                    if ($product_download->display_filename != '') {
                        $assign[$key]['name'] = $product_download->display_filename;
                        $dl_link = $product_download->getTextLink(false, $virtual_product['download_hash'])
                            . '&id_order=' . (int) $order->id
                            . '&secure_key=' . $order->secure_key;
                        $assign[$key]['link'] = $dl_link;
                        if (isset($virtual_product['download_deadline']) && $virtual_product['download_deadline'] != '0000-00-00 00:00:00') {
                            $assign[$key]['deadline'] = Tools::displayDate($virtual_product['download_deadline']);
                        }
                        if ($product_download->nb_downloadable != 0) {
                            $assign[$key]['downloadable'] = (int) $product_download->nb_downloadable;
                        }
                    }
                }

                $customer = new Customer((int) $order->id_customer);
                $links = [];
                foreach ($assign as $product) {
                    $complementaryText = [];
                    if (isset($product['deadline'])) {
                        $complementaryText[] = $this->trans('expires on %s.', [$product['deadline']], 'Admin.Orderscustomers.Notification');
                    }
                    if (isset($product['downloadable'])) {
                        $complementaryText[] = $this->trans('downloadable %d time(s)', [(int) $product['downloadable']], 'Admin.Orderscustomers.Notification');
                    }
                    $links[] = [
                        'text' => Tools::htmlentitiesUTF8($product['name']),
                        'url' => $product['link'],
                        'complementary_text' => implode(' ', $complementaryText),
                    ];
                }

                $context = Context::getContext();
                $partialRenderer = new MailPartialTemplateRenderer($context->smarty);

                $links_txt = $partialRenderer->render('download_product_virtual_products.txt', $context->language, $links, true);
                $links_html = $partialRenderer->render('download_product_virtual_products.tpl', $context->language, $links);

                $data = [
                    '{lastname}' => $customer->lastname,
                    '{firstname}' => $customer->firstname,
                    '{id_order}' => (int) $order->id,
                    '{order_name}' => $order->getUniqReference(),
                    '{nbProducts}' => count($virtual_products),
                    '{virtualProducts}' => $links_html,
                    '{virtualProductsTxt}' => $links_txt,
                ];
                // If there is at least one downloadable file
                if (!empty($assign)) {
                    $orderLanguage = new Language((int) $order->id_lang);
                    Mail::Send(
                        (int) $order->id_lang,
                        'download_product',
                        Context::getContext()->getTranslator()->trans(
                            'The virtual product that you bought is available for download',
                            [],
                            'Emails.Subject',
                            $orderLanguage->locale
                        ),
                        $data,
                        $customer->email,
                        $customer->firstname . ' ' . $customer->lastname,
                        null,
                        null,
                        null,
                        null,
                        _PS_MAIL_DIR_,
                        false,
                        (int) $order->id_shop
                    );
                }
            }

            /** @since 1.5.0 : gets the stock manager */
            $manager = null;
            if (Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT')) {
                $manager = StockManagerFactory::getManager();
            }

            $error_or_canceled_statuses = [Configuration::get('PS_OS_ERROR'), Configuration::get('PS_OS_CANCELED')];

            $employee = null;
            if (!(int) 1 || !Validate::isLoadedObject(($employee = new Employee((int) 1)))) {
                if (!Validate::isLoadedObject($old_os) && $context != null) {
                    // First OrderHistory, there is no $old_os, so $employee is null before here
                    $employee = $context->employee; // filled if from BO and order created (because no old_os)
                    if ($employee) {
                       // $this->id_employee = $employee->id;
                    }
                } else {
                    $employee = null;
                }
            }

            // foreach products of the order
            foreach ($order->getProductsDetail() as $product) {
                if (Validate::isLoadedObject($old_os)) {
                    // if becoming logable => adds sale
                    if ($new_os->logable && !$old_os->logable) {
                        ProductSale::addProductSale($product['product_id'], $product['product_quantity']);
                        // @since 1.5.0 - Stock Management
                        if (!Pack::isPack($product['product_id']) &&
                            in_array($old_os->id, $error_or_canceled_statuses) &&
                            !StockAvailable::dependsOnStock($product['id_product'], (int) $order->id_shop)) {
                            StockAvailable::updateQuantity($product['product_id'], $product['product_attribute_id'], -(int) $product['product_quantity'], $order->id_shop);
                        }
                    } elseif (!$new_os->logable && $old_os->logable) {
                        // if becoming unlogable => removes sale
                        ProductSale::removeProductSale($product['product_id'], $product['product_quantity']);

                        // @since 1.5.0 - Stock Management
                        if (!Pack::isPack($product['product_id']) &&
                            in_array($new_os->id, $error_or_canceled_statuses) &&
                            !StockAvailable::dependsOnStock($product['id_product'])) {
                            StockAvailable::updateQuantity($product['product_id'], $product['product_attribute_id'], (int) $product['product_quantity'], $order->id_shop);
                        }
                    } elseif (!$new_os->logable && !$old_os->logable &&
                        in_array($new_os->id, $error_or_canceled_statuses) &&
                        !in_array($old_os->id, $error_or_canceled_statuses) &&
                        !StockAvailable::dependsOnStock($product['id_product'])
                    ) {
                        // if waiting for payment => payment error/canceled
                        StockAvailable::updateQuantity($product['product_id'], $product['product_attribute_id'], (int) $product['product_quantity'], $order->id_shop);
                    }
                }
                // From here, there is 2 cases : $old_os exists, and we can test shipped state evolution,
                // Or old_os does not exists, and we should consider that initial shipped state is 0 (to allow decrease of stocks)

                // @since 1.5.0 : if the order is being shipped and this products uses the advanced stock management :
                // decrements the physical stock using $id_warehouse
                if ($new_os->shipped == 1 && (!Validate::isLoadedObject($old_os) || $old_os->shipped == 0) &&
                    Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') &&
                    Warehouse::exists($product['id_warehouse']) &&
                    $manager != null &&
                    (int) $product['advanced_stock_management'] == 1) {
                    // gets the warehouse
                    $warehouse = new Warehouse($product['id_warehouse']);

                    // decrements the stock (if it's a pack, the StockManager does what is needed)
                    $manager->removeProduct(
                        $product['product_id'],
                        $product['product_attribute_id'],
                        $warehouse,
                        ($product['product_quantity'] - $product['product_quantity_refunded'] - $product['product_quantity_return']),
                        Configuration::get('PS_STOCK_CUSTOMER_ORDER_REASON'),
                        true,
                        (int) $order->id,
                        0,
                        $employee
                    );
                } elseif ($new_os->shipped == 0 && Validate::isLoadedObject($old_os) && $old_os->shipped == 1 &&
                    Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') &&
                    Warehouse::exists($product['id_warehouse']) &&
                    $manager != null &&
                    (int) $product['advanced_stock_management'] == 1
                ) {
                    // @since.1.5.0 : if the order was shipped, and is not anymore, we need to restock products

                    // if the product is a pack, we restock every products in the pack using the last negative stock mvts
                    if (Pack::isPack($product['product_id'])) {
                        $pack_products = Pack::getItems($product['product_id'], Configuration::get('PS_LANG_DEFAULT', null, null, $order->id_shop));
                        foreach ($pack_products as $pack_product) {
                            if ($pack_product->advanced_stock_management == 1) {
                                $mvts = StockMvt::getNegativeStockMvts($order->id, $pack_product->id, 0, $pack_product->pack_quantity * $product['product_quantity']);
                                foreach ($mvts as $mvt) {
                                    $manager->addProduct(
                                        $pack_product->id,
                                        0,
                                        new Warehouse($mvt['id_warehouse']),
                                        $mvt['physical_quantity'],
                                        null,
                                        $mvt['price_te'],
                                        true,
                                        null,
                                        $employee
                                    );
                                }
                                if (!StockAvailable::dependsOnStock($product['id_product'])) {
                                    StockAvailable::updateQuantity($pack_product->id, 0, (int) $pack_product->pack_quantity * $product['product_quantity'], $order->id_shop);
                                }
                            }
                        }
                    } else {
                        // else, it's not a pack, re-stock using the last negative stock mvts

                        $mvts = StockMvt::getNegativeStockMvts(
                            $order->id,
                            $product['product_id'],
                            $product['product_attribute_id'],
                            ($product['product_quantity'] - $product['product_quantity_refunded'] - $product['product_quantity_return'])
                        );

                        foreach ($mvts as $mvt) {
                            $manager->addProduct(
                                $product['product_id'],
                                $product['product_attribute_id'],
                                new Warehouse($mvt['id_warehouse']),
                                $mvt['physical_quantity'],
                                null,
                                $mvt['price_te'],
                                true
                            );
                        }
                    }
                }

                // Save movement if :
                // not Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT')
                // new_os->shipped != old_os->shipped
                if (Validate::isLoadedObject($old_os) && Validate::isLoadedObject($new_os) && $new_os->shipped != $old_os->shipped && !Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT')) {
                    $product_quantity = (int) ($product['product_quantity'] - $product['product_quantity_refunded'] - $product['product_quantity_return']);

                    if ($product_quantity > 0) {
                        $current_shop_context_type = Context::getContext()->shop->getContextType();
                        if ($current_shop_context_type !== Shop::CONTEXT_SHOP) {
                            //change to order shop context
                            $current_shop_group_id = Context::getContext()->shop->getContextShopGroupID();
                            Context::getContext()->shop->setContext(Shop::CONTEXT_SHOP, $order->id_shop);
                        }
                        (new StockManager())->saveMovement(
                            (int) $product['product_id'],
                            (int) $product['product_attribute_id'],
                            (int) $product_quantity * ($new_os->shipped == 1 ? -1 : 1),
                            [
                                'id_order' => $order->id,
                                'id_stock_mvt_reason' => ($new_os->shipped == 1 ? Configuration::get('PS_STOCK_CUSTOMER_ORDER_REASON') : Configuration::get('PS_STOCK_CUSTOMER_ORDER_CANCEL_REASON')),
                            ]
                        );
                        //back to current shop context
                        if ($current_shop_context_type !== Shop::CONTEXT_SHOP) {
                            Context::getContext()->shop->setContext($current_shop_context_type, $current_shop_group_id);
                        }


                       
                    }
                }
            }
        }

        //Paso de nuevo para no liarme
          $error_or_canceled_statuses = [Configuration::get('PS_OS_ERROR'), Configuration::get('PS_OS_CANCELED')];
         foreach ($order->getProductsDetail() as $product) 
         {

            
            
              $lang_id = Context::getContext()->language->id;
            $productT = new Product($product['product_id'], false, $lang_id);
            $product_name=$productT->name;
            $reference=$productT->reference;

            if($product['product_attribute_id']>0)
            {
                //Obtener Referencia
                $reference=OrderHistory::getReferenceAtributo($product['product_id'],$product['product_attribute_id']);
                $product_name=$product_name. " - ". OrderHistory::getNameAtributo($product['product_attribute_id']);

            }
            


            $id_product=$product['product_id'];
            $id_product_attribute=$product['product_attribute_id'];
            $product_quantity=$product['product_quantity'];
            //Si cambiamos a error o cancelado tenemos que restaurar stock

            if($old_os){

                $condicion=false;

            if (in_array($new_os->id, $error_or_canceled_statuses) &&
                        !in_array($old_os->id, $error_or_canceled_statuses) and (!$condicion))
            {

                //Aquí

              $sql = 'SELECT * FROM '._DB_PREFIX_.'stock_available_advanced WHERE id_product="'.$id_product.'" and id_product_attribute="'.$id_product_attribute.'" order by date_add DESC';
              $comments="Cambios de Pedidos";

              if($old_os->shipped==1)
              {
                $mvt_reserved=0;
                $mvt_physical=$product_quantity;

               if($row = Db::getInstance()->getRow($sql)){
                    $reserved_quantity=$row['reserved_quantity'];
                    $physical_quantity=$row['stock_quantity']+$product_quantity;
               }
                else{
                     $reserved_quantity=0;
                     $physical_quantity=$product_quantity;
                 }
                 $date_add= date('Y-m-d H:i:s');
               
               $sign=-1;
               if($mvt_physical>=0)
                    $sign=1;
              
               
               
               
              }
              else
              {

                $mvt_reserved=0;
                $mvt_physical=$product_quantity;

               if($row = Db::getInstance()->getRow($sql)){
                    $reserved_quantity=$row['reserved_quantity']-$product_quantity;
                    $physical_quantity=$row['stock_quantity']+$product_quantity;
               }
                else{
                     $reserved_quantity=0;
                     $physical_quantity=$product_quantity;
                 }
                 $date_add= date('Y-m-d H:i:s');
               
               $sign=-1;
               if($mvt_physical>0)
                    $sign=1;
               


                
              }

              
              $id_stock_mvt_reason="Cancelado o Error";
               $stock_available=new StockAvailable(StockAvailable::getStockAvailableIdByProductId($id_product, $id_product_attribute));
               $stock_quantity= $stock_available->quantity;
               $id_order=$order->id;
               $id_order_status=$new_os->id;
               $id_employee = Context::getContext()->employee->id;

   

                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'","'.$id_product_attribute.'","'.$id_order.'","'.$id_order_status.'","'.$stock_quantity.'","'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'","'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'","'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';

                                 

                    Db::getInstance()->execute($sql);

                    $condicion=true;

            }

            //Si sólo pagado o es espera de pago banco

            if (($new_os->shipped == 0 && $old_os->shipped == 0) and (!$condicion))
            {

                  //Aquí

              $sql = 'SELECT * FROM '._DB_PREFIX_.'stock_available_advanced WHERE id_product="'.$id_product.'" and id_product_attribute="'.$id_product_attribute.'" order by date_add DESC';
              $comments="Cambios de Pedidos";

              $mvt_reserved=0;

              $stock_available=new StockAvailable(StockAvailable::getStockAvailableIdByProductId($id_product, $id_product_attribute));
               $stock_quantity= $stock_available->quantity;

               if($row = Db::getInstance()->getRow($sql)){
                    $reserved_quantity=$row['reserved_quantity'];
                    $physical_quantity=$row['physical_quantity'];
               }
                else{
                     $reserved_quantity=0;
                     $physical_quantity=$stock_quantity;
                 }
                 $date_add= date('Y-m-d H:i:s');
               $id_stock_mvt_reason="Cambio Estado Pedido";
               $sign=-1;
               if($mvt_reserved>=0)
                    $sign=1;
               
               $mvt_physical=0;

               $id_order=$order->id;
               $id_order_status=$new_os->id;
               $id_employee = Context::getContext()->employee->id;

   

                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'","'.$id_product_attribute.'","'.$id_order.'","'.$id_order_status.'","'.$stock_quantity.'","'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'","'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'","'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';

                                 

                    Db::getInstance()->execute($sql);


                    $condicion=true;
            //

            }

            

            //Si enviamos

            if (($new_os->shipped == 1 && $old_os->shipped == 0) and (!$condicion))
            {

                     //Aquí

              $sql = 'SELECT * FROM '._DB_PREFIX_.'stock_available_advanced WHERE id_product="'.$id_product.'" and id_product_attribute="'.$id_product_attribute.'" order by date_add DESC';
              $comments="Pedido Enviado";

              $mvt_reserved=0;

              $stock_available=new StockAvailable(StockAvailable::getStockAvailableIdByProductId($id_product, $id_product_attribute));
               $stock_quantity= $stock_available->quantity;

               if($row = Db::getInstance()->getRow($sql)){
                    $reserved_quantity=$row['reserved_quantity']-$product_quantity;
                    $physical_quantity=$row['physical_quantity']-$product_quantity;
               }
                else{
                     $reserved_quantity=0;
                     $physical_quantity=$stock_available->quantity;
                 }
                 $date_add= date('Y-m-d H:i:s');
               $id_stock_mvt_reason="Cambio Estado Pedido";
               
               
               
               $mvt_physical=-$product_quantity;

               $sign=-1;
               if($mvt_physical>=0)
                    $sign=1;

               $id_order=$order->id;
               $id_order_status=$new_os->id;
               $id_employee = Context::getContext()->employee->id;

   

                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'","'.$id_product_attribute.'","'.$id_order.'","'.$id_order_status.'","'.$stock_quantity.'","'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'","'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'","'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';

                                 

                    Db::getInstance()->execute($sql);

                    $condicion=true;
            }

             if (($new_os->shipped == 1 && $old_os->shipped == 1) and (!$condicion))
            {
                   //Aquí

              $sql = 'SELECT * FROM '._DB_PREFIX_.'stock_available_advanced WHERE id_product="'.$id_product.'" and id_product_attribute="'.$id_product_attribute.'" order by date_add DESC';
              $comments="Pedido Sigue Enviado";

              $mvt_reserved=0;

              $stock_available=new StockAvailable(StockAvailable::getStockAvailableIdByProductId($id_product, $id_product_attribute));
               $stock_quantity= $stock_available->quantity;

               if($row = Db::getInstance()->getRow($sql)){
                    $reserved_quantity=$row['reserved_quantity'];
                    $physical_quantity=$row['physical_quantity'];
               }
                else{
                     $reserved_quantity=0;
                     $physical_quantity=$stock_available->quantity;
                 }
                 $date_add= date('Y-m-d H:i:s');
               $id_stock_mvt_reason="Cambio Estado Pedido";
               
               
               
               $mvt_physical=0;

               $sign=-1;
               if($mvt_physical>=0)
                    $sign=1;

               $id_order=$order->id;
               $id_order_status=$new_os->id;
               $id_employee = Context::getContext()->employee->id;

   

                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'","'.$id_product_attribute.'","'.$id_order.'","'.$id_order_status.'","'.$stock_quantity.'","'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'","'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'","'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';

                                 

                    Db::getInstance()->execute($sql);

                    $condicion=true;
            }
        }
        else
        {

             if ($new_os->shipped == 0)
            {

                  //Aquí

              $sql = 'SELECT * FROM '._DB_PREFIX_.'stock_available_advanced WHERE id_product="'.$id_product.'" and id_product_attribute="'.$id_product_attribute.'" order by date_add DESC';
              $comments="Cambios de Pedidos";

               $stock_available=new StockAvailable(StockAvailable::getStockAvailableIdByProductId($id_product, $id_product_attribute));
               $stock_quantity= $stock_available->quantity;

              $mvt_reserved=-$product_quantity;

               if($row = Db::getInstance()->getRow($sql)){
                    $reserved_quantity=$product_quantity + $row['reserved_quantity'];
                     $physical_quantity=$row['physical_quantity'];
               }
                else{
                     $reserved_quantity=$product_quantity;
                     $physical_quantity=$stock_quantity;
                 }
                 $date_add= date('Y-m-d H:i:s');
               $id_stock_mvt_reason="Cambio Estado Pedido";
               $sign=-1;
               if($mvt_reserved>=0)
                    $sign=1;

                    
               
               $mvt_physical=0;

               $id_order=$order->id;
               $id_order_status=$new_os->id;
               $id_employee = Context::getContext()->employee->id;

   

                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'","'.$id_product_attribute.'","'.$id_order.'","'.$id_order_status.'","'.$stock_quantity.'","'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'","'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'","'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';

                                 

                    Db::getInstance()->execute($sql);




             }

              if ($new_os->shipped == 1) 
            {

                     //Aquí

              $sql = 'SELECT * FROM '._DB_PREFIX_.'stock_available_advanced WHERE id_product="'.$id_product.'" and id_product_attribute="'.$id_product_attribute.'" order by date_add DESC';
              $comments="Pedido Enviado";

              $mvt_reserved=0;

               if($row = Db::getInstance()->getRow($sql)){
                    $reserved_quantity=$row['reserved_quantity']-$product_quantity;
               }
                else{
                     $reserved_quantity=0;
                 }
                 $date_add= date('Y-m-d H:i:s');
               $id_stock_mvt_reason="Cambio Estado Pedido";

               $stock_available=new StockAvailable(StockAvailable::getStockAvailableIdByProductId($id_product, $id_product_attribute));
               $stock_quantity= $stock_available->quantity;
               
               if($row['physical_quantity'])
               $physical_quantity=$row['physical_quantity']-$product_quantity;
               else
                 $physical_quantity=$stock_quantity;

               
               $mvt_physical=-$product_quantity;

               $sign=-1;
               if($mvt_physical>=0)
                    $sign=1;

               $id_order=$order->id;
               $id_order_status=$new_os->id;
               $id_employee = Context::getContext()->employee->id;

   

                $sql = 'INSERT INTO ' . _DB_PREFIX_ .'stock_available_advanced (product_name,reference,id_product,id_product_attribute,id_order,id_order_status,stock_quantity,physical_quantity,reserved_quantity,mvt_physical,mvt_reserved,sign,id_employee,reason_presta,comments,date_add) VALUES ("'.$product_name.'","'.$reference.'","'.$id_product.'","'.$id_product_attribute.'","'.$id_order.'","'.$id_order_status.'","'.$stock_quantity.'","'.$physical_quantity.'","'.$reserved_quantity.'","'.$mvt_physical.'","'.$mvt_reserved.'","'.$sign.'","'.$id_employee.'","'.$id_stock_mvt_reason.'","'.$comments.'","'.$date_add.'")';

                                 

                    Db::getInstance()->execute($sql);
            }
            } 

         }


        $this->id_order_state = (int) $new_order_state;

        // changes invoice number of order ?
        if (!Validate::isLoadedObject($new_os) || !Validate::isLoadedObject($order)) {
            die(Tools::displayError($this->trans('Invalid new order status', [], 'Admin.Orderscustomers.Notification')));
        }

        // the order is valid if and only if the invoice is available and the order is not cancelled
        $order->current_state = $this->id_order_state;
        $order->valid = $new_os->logable;
        $order->update();

        if ($new_os->invoice && !$order->invoice_number) {
            $order->setInvoice($use_existing_payment);
        } elseif ($new_os->delivery && !$order->delivery_number) {
            $order->setDeliverySlip();
        }

        // set orders as paid
        if ($new_os->paid == 1) {
            $invoices = $order->getInvoicesCollection();
            if ($order->total_paid != 0) {
                $payment_method = Module::getInstanceByName($order->module);
            }

            foreach ($invoices as $invoice) {
                /** @var OrderInvoice $invoice */
                $rest_paid = $invoice->getRestPaid();
                if ($rest_paid > 0) {
                    $payment = new OrderPayment();
                    $payment->order_reference = Tools::substr($order->reference, 0, 9);
                    $payment->id_currency = $order->id_currency;
                    $payment->amount = $rest_paid;

                    if ($order->total_paid != 0) {
                        $payment->payment_method = $payment_method->displayName;
                    } else {
                        $payment->payment_method = null;
                    }

                    // Update total_paid_real value for backward compatibility reasons
                    if ($payment->id_currency == $order->id_currency) {
                        $order->total_paid_real += $payment->amount;
                    } else {
                        $order->total_paid_real += Tools::ps_round(Tools::convertPrice($payment->amount, $payment->id_currency, false), Context::getContext()->getComputingPrecision());
                    }
                    $order->save();

                    $payment->conversion_rate = ($order ? $order->conversion_rate : 1);
                    $payment->save();
                    Db::getInstance()->execute('
                    INSERT INTO `' . _DB_PREFIX_ . 'order_invoice_payment` (`id_order_invoice`, `id_order_payment`, `id_order`)
                    VALUES(' . (int) $invoice->id . ', ' . (int) $payment->id . ', ' . (int) $order->id . ')');
                }
            }
        }

        // updates delivery date even if it was already set by another state change
        if ($new_os->delivery) {
            $order->setDelivery();
        }

        // executes hook
        Hook::exec('actionOrderStatusPostUpdate', ['newOrderStatus' => $new_os, 'id_order' => (int) $order->id], null, false, true, false, $order->id_shop);

        // sync all stock
        (new StockManagerAdapter())->updatePhysicalProductQuantity(
            (int) $order->id_shop,
            (int) Configuration::get('PS_OS_ERROR'),
            (int) Configuration::get('PS_OS_CANCELED'),
            null,
            (int) $order->id
        );

        ShopUrl::resetMainDomainCache();
    }

    public function getReferenceAtributo($id_product,$id_product_attribute)
    {
        $sql = 'SELECT  reference ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'product_attribute p ';
        $sql .= 'WHERE p.id_product_attribute=' . $id_product_attribute . ' and p.id_product=' . $id_product .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['reference'];
        }
        else
            return "";

    }

    public function getNameAtributo($id_product_attribute)
    {
        //lang
        $id_lang=Context::getContext()->language->id;
        $sql = 'SELECT  name ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'attribute_lang a ';
        $sql .= 'WHERE a.id_attribute=' . $id_product_attribute . ' and a.id_lang=' . $id_lang .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['name'];
        }
        else
            return "";

    }
}