<?php
/**
 * 2007-2020 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2020 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

if (!defined('_PS_VERSION_')) {
    exit;
}
class gestavdstock extends Module
{
    public function __construct()
    {
        if (Tools::version_compare(_PS_VERSION_, '1.7.0', '>=')) {
            $this->is17 = true;
        }
        $this->name        = 'gestavdstock';
        $this->tab         = 'administration';
        $this->version     = '1.0.0';
        $this->author      = 'Clearis UControl S.L.';
        $this->displayName = $this->l('Advanced stock management for todoCampers');
        $this->description = $this->l('This module allows you to view stock movements, add comments and import / export.');
        $this->bootstrap   = true;
        $this->configure   = false;
        $this->module_key  = '';
        parent::__construct();
        $this->ps_versions_compliancy = ['min' => '1.6', 'max' => _PS_VERSION_];
    }
    
    
    public function install()
    {
        if ($this->is17) {
            if (!parent::install()) {
                return false;
            }
        } else {
            if (!parent::install() || !$this->registerHook('backOfficeHeader')) {
                return false;
            }
        }
        

        if (Shop::isFeatureActive()) {
            Shop::setContext(Shop::CONTEXT_ALL);
        }
       
        $lang            = Language::getLanguages();
        $tab             = new Tab();
        $tab->class_name = 'GestAvdStockMvt';
        $tab->module     = $this->name;
        $tab->id_parent = 2;
        
        foreach ($lang as $l) {
            $title = $this->l('Advanced Stock Management');
            $lang  = Language::getIsoById($l['id_lang']);
            if ($lang == 'es') {
                $title = "Gestión Avanzada de Stock - Movimientos";
            }
            if ($lang == 'en') {
                $title = "Advanced Stock Management Movements";
            }
            if ($lang == 'it') {
                $title = "Advanced Stock Management Movements";
            }
            if ($lang == 'fr') {
                $title = "Advanced Stock Management Movements";
            }
            if ($lang == 'pt') {
                $title = "Advanced Stock Management Movements";
            }
            $tab->name[$l['id_lang']] = $title;
        }
        $tab->save();

        $lang            = Language::getLanguages();
        $tab             = new Tab();
        $tab->class_name = 'GestAvdStock';
        $tab->module     = $this->name;
        $tab->id_parent = 2;

        foreach ($lang as $l) {
            $title = $this->l('Advanced Stock Management');
            $lang  = Language::getIsoById($l['id_lang']);
            if ($lang == 'es') {
                $title = "Gestión Avanzada de Stock";
            }
            if ($lang == 'en') {
                $title = "Advanced Stock Management";
            }
            if ($lang == 'it') {
                $title = "Advanced Stock Management";
            }
            if ($lang == 'fr') {
                $title = "Advanced Stock Management";
            }
            if ($lang == 'pt') {
                $title = "Advanced Stock Management";
            }
            $tab->name[$l['id_lang']] = $title;
        }
        $tab->save();

       $this->_installSql();

        return true;
    }


    public function uninstall()
    {
        // Uninstall Tabs
        $tab = new Tab((int) Tab::getIdFromClassName('GestAvdStockMvt'));
        if($tab)
        $tab->delete();

        $tab = new Tab((int) Tab::getIdFromClassName('GestAvdStock'));
        if($tab)
            $tab->delete();

         $this->_unInstallSql();
        // Uninstall Module
        if (!parent::uninstall()) {
            return false;
        }
       
        return true;
    }

    protected function _installSql()
    {
        $sqlInstall = "CREATE TABLE IF NOT EXISTS " . _DB_PREFIX_ . "stock_available_advanced (`id_stock_available_advanced` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_product` int(11) NOT NULL,
  `id_product_attribute` int(11) unsigned DEFAULT NULL,
  `product_name` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `id_order` int(11) DEFAULT NULL,
  `id_order_status` int(11) DEFAULT NULL,
  `stock_quantity` int(10) NOT NULL DEFAULT '0',
  `physical_quantity` int(11) NOT NULL DEFAULT '0',
  `reserved_quantity` int(11) NOT NULL DEFAULT '0',
  `mvt_physical` int(11) NOT NULL DEFAULT '0',
  `mvt_reserved` int(11) NOT NULL DEFAULT '0',
  `sign` smallint(6) NOT NULL DEFAULT '1',
  `id_employee` int(11) NOT NULL,
  `reason_presta` varchar(255) NOT NULL DEFAULT '',
  `comments` varchar(255) DEFAULT NULL,
  `date_add` datetime NOT NULL,
  PRIMARY KEY (`id_stock_available_advanced`)
);";
$returnSql = Db::getInstance()->execute($sqlInstall);

    //insertar el estado 0 para idiomas

 $lang            = Language::getLanguages();
    foreach ($lang as $l) {
           $sqlInstall="INSERT INTO " . _DB_PREFIX_ . "order_state_lang(`id_order_state`, `id_lang`, `name`, `template`) VALUES (0, ".$l['id_lang'].", '-', '');";
		   $returnSql = Db::getInstance()->execute($sqlInstall);
           $sqlInstall="INSERT INTO " . _DB_PREFIX_ . "employee(`id_employee`,`firstname`,`id_lang`) VALUES (0,'Cliente','1');";
		   $returnSql = Db::getInstance()->execute($sqlInstall);
    }




         //preparar carga de datos stock actual
    /*
    $sql="select * from " . _DB_PREFIX_ . "stock_available";
    $stocksa = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
    $sqlstock="";
    $id_employee = Context::getContext()->employee->id;
      $date_add= date('Y-m-d H:i:s');
    foreach($stocksa as $stock)
    {
  
        $lang_id = Context::getContext()->language->id;
        $productT = new Product($stock['id_product'], false, $lang_id);
            $product_name=$productT->name;
            $reference=$productT->reference;
            $comments="StockInicial";

            if($stock['id_product_attribute']>0)
            {
                //Obtener Referencia
                $reference=StockAvailable::getReferenceAtributo($stock['id_product'],$stock['id_product_attribute']);
                $product_name=$product_name. " - ". StockAvailable::getNameAtributo($stock['id_product_attribute']);

            }



        $sqlstock.="INSERT INTO " . _DB_PREFIX_ . "stock_available_advanced(`product_name`,`reference`,`id_product`, `id_product_attribute`, `stock_quantity`, `physical_quantity`,`reserved_quantity`,id_order,id_order_status,id_employee,comments,date_add) VALUES ('".$product_name."','".$reference."',".$stock['id_product'].", ".$stock['id_product_attribute'].", ".$stock['quantity'].", ".$stock['physical_quantity'].",".$stock['reserved_quantity'].",0,0,".$id_employee.",'".$comments."','".$date_add."');";
    }
    if($sqlstock!="")
    Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sqlstock);
*/


        return $returnSql;
    }

     protected function _unInstallSql()
    {
        $sqlInstall = "DROP TABLE IF EXISTS " . _DB_PREFIX_ . "stock_available_advanced;";
        $returnSql   = Db::getInstance()->execute($sqlInstall);
        
        

	   $sqlInstall = "DELETE FROM " . _DB_PREFIX_ . "order_state_lang where id_order_state=0;";
	   $returnSql   = Db::getInstance()->execute($sqlInstall);
	   $sqlInstall = "DELETE FROM " . _DB_PREFIX_ . "employee where id_employee=0";

           $returnSql   = Db::getInstance()->execute($sqlInstall);
          

        return $returnSql;
    }

    ///////////////////// FUNCIONES DE LOG
public function escribirLog($texto) {
    
        // Log
        $logfilename = _PS_MODULE_DIR_.'gestavdstock/logs/todocampers.log';
        if( file_exists( $logfilename ) ) {
            file_put_contents($logfilename, date('M d Y G:i:s') . ' -- ' . $texto . "\r\n", is_file($logfilename)?FILE_APPEND:0);
        }
    }


    

    
}
