<?php
/**
 * 2007-2020 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2020 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */


if (!defined('_PS_VERSION_')) exit;

class GestAvdStockController extends ModuleAdminController
{


public function __construct()
    {
        $this->bootstrap = true;
        parent::__construct();
        $this->context = Context::getContext();
        $this->_html   = '';
    }
    public function init()
    {
        parent::init();
    }
    public function initContent()
    {
        parent::initContent();
        $filter                        = false;
        $reset                         = false;
        $this->context->cookie->filter = false;
        if (Tools::isSubmit('npag2')) {
            $this->context->cookie->mostradosPorPagina = Tools::getValue('ordersxpag');
        }
        if (Tools::isSubmit('order_pagination')) {
            $this->context->cookie->mostradosPorPagina = Tools::getValue('order_pagination');
        }
        if (!$this->context->cookie->mostradosPorPagina) {
            //mostrar 10 facturas por defecto
            $mostradosPorPagina = 10;
        } else {
            $mostradosPorPagina = $this->context->cookie->mostradosPorPagina;
        }
        $mensaje = false;
        $info    = false;

        if (!Tools::isSubmit('searchMovimientos'))
            $reset=true;

        if (Tools::isSubmit('uploadCSV'))
        {

        
                    $row = 1;
                     $handle = fopen($_FILES['file']['tmp_name'], "r");
                    $headers = fgetcsv($handle, 1000, ";");
                    $estados=array();
                    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) 
                    {
                        if(count($data)==3)
                        {
                            $reference=$data[0];
                            $quantity=$data[1];
                            $comments=$data[2];
                            
                          
                           $estado= StockAvailable::insertInventario($reference,$quantity,$comments,$row);

                           
                           
                           if($estado)
                            $estados[]=$estado;
                            $row++;

                        }
                       
                    }
            fclose($handle);
                if($estados)
                {
                    $mensaje=true;
                    $men0   = "Errores en importación: ";
                    $men1   = "Importación ok: ";
                    foreach($estados as $e)
                    {
                        if($e[0]!="Ok")
                            $men0 .=$e[1]." :: ".$e[2].", ";
                        else
                            $men1 .=" ".$e[1].$e[2]." || ";
                    }
                    if($men0!="Errores en importación: ")
                    $info[0]=$men0;   
                    $info[1]=$men1;

                }
    
        } 



        if (Tools::isSubmit('searchMovimientos')) {
            $task            = Tools::getValue('submitState');
            $movimientoSelected = Tools::getValue('id_stock_available_advancedSelected');
            $control         = false;
            $p=0;

            
            if ($task < 9) {
                if ($movimientoSelected != "") {
                    $control = false;
                } else {
                    $control = true;
                }
            }


            if (!$control) {
                switch ($task) {
                    case 1:
                        $tipo = "CSV";
                        $this->createCSV($movimientoSelected, $tipo);
                        break;
                    case 2:
                        $tipo     = "CSV";
                        $fileName = $this->createCSV($movimientoSelected, $tipo, true);
                        $info     = $this->sendMailCSV($fileName);
                        $mensaje  = true;
                        break;
                    case 3:
                        $tipo = "XLSX";
                        $this->createCSV($movimientoSelected, $tipo);
                        break;
                    case 4:
                        $tipo     = "XLSX";
                        $fileName = $this->createCSV($movimientoSelected, $tipo, true);
                        $info     = $this->sendMailXLSX($fileName);
                        $mensaje  = true;
                        break;
                    case 5:
                        $info=$this->cambiarStock($movimientoSelected);
                        $mensaje  = true;
                        break;
                    case 6:
                        $fileName = $this->createPDF($movimientoSelected, true);
                        $info     = $this->sendMailPDF($fileName);
                        $mensaje  = true;
                        break;
                    case 7:
                        $this->importarCSV();
                        break;
                    case 8:
                        $info    = $this->sendMailImprimirFacturas($movimientoSelected);
                        $mensaje = true;
                        break;
                    case 9:
                        $filter = true;
                        break;
                    case 10:
                        $reset = true;
                        break;
                    case 11:
                        $filter = true;
                        break;
                    default:
                        # code...
                        break;
                }
                foreach (glob("../modules/gestavdstock/tmp/*.*") as $filename) {
                    if (strpos($filename, 'index.php') === false) {
                        unlink($filename);
                    }
                }
            } else {
                $info    = array($this->l('You must select the items to export reports'), false);
                $mensaje = true;
            }
        }
        $paginaActual = 1;
        if (Tools::isSubmit('npag')) {
            $paginaActual = Tools::getValue('numpag');
        }
        $movimientoInicial = ($paginaActual - 1) * $mostradosPorPagina;
        $sql            = 'SELECT COUNT(*) AS total FROM `' . _DB_PREFIX_ . 'stock_available_advanced`';
        $fila           = Db::getInstance()->executeS($sql);
        $cont_movimientos  = $fila[0]['total'];
        /************************/
        if ($filter) {

            $this->context->cookie->f_product_name           = Tools::getValue('movimientosFilter_product_name');
            $this->context->cookie->f_reference          = Tools::getValue('movimientosFilter_reference');
            $this->context->cookie->f_manufacturer          = Tools::getValue('movimientosFilter_manufacturer');
            $this->context->cookie->f_order    = Tools::getValue('movimientosFilter_f_order');
            $this->context->cookie->f_order_status_name = Tools::getValue('movimientosFilter_order_status_name');
            $this->context->cookie->f_stock_quantity              = Tools::getValue('movimientosFilter_stock_quantity');
            $this->context->cookie->f_physical_quantity          = Tools::getValue('movimientosFilter_physical_quantity');
            $this->context->cookie->f_reserved_quantity          = Tools::getValue('movimientosFilter_reserved_quantity');
            $this->context->cookie->f_mvt_physical   = Tools::getValue('movimientosFilter_mvt_physical');
            $this->context->cookie->f_mvt_reserved  = Tools::getValue('movimientosFilter_mvt_reserved');
            $this->context->cookie->f_sign      = Tools::getValue('movimientosFilter_sign');
            $this->context->cookie->f_employee      = Tools::getValue('movimientosFilter_employee');
            $this->context->cookie->f_reason_presta      = Tools::getValue('movimientosFilter_reason_presta');
            $this->context->cookie->f_comments     = Tools::getValue('movimientosFilter_comments');
            $this->context->cookie->f_date_ini         = Tools::getValue('movimientosFilter_date_ini');
            $this->context->cookie->f_date_fin         = Tools::getValue('movimientosFilter_date_fin');
            if ($this->context->cookie->f_date_ini == '') {
                $f_date_ini = "1970-01-01 00:00:00";
            } else {
                $ini                               = explode("/", $this->context->cookie->f_date_ini);
                $f_date_ini                        = $ini[2] . '-' . $ini[1] . '-' . $ini[0] . ' 00:00:00';
                $this->context->cookie->f_date_ini = $f_date_ini;
            }
            if ($this->context->cookie->f_date_fin == '') {
                $f_date_fin = date("Y-m-d H:i:s");
            } else {
                $fin                               = explode("/", $this->context->cookie->f_date_fin);
                $f_date_fin                        = $fin[2] . '-' . $fin[1] . '-' . $fin[0] . ' 23:59:59';
                $this->context->cookie->f_date_fin = $f_date_fin;
            }
            $this->context->cookie->filter = true;
        }


        if ($reset) {
            unset($this->context->cookie->f_product_name);
            unset($this->context->cookie->f_reference);
            unset($this->context->cookie->f_manufacturer);
            unset($this->context->cookie->f_order);
            unset($this->context->cookie->f_order_status_name);
            unset($this->context->cookie->f_stock_quantity);
            unset($this->context->cookie->f_physical_quantity);
            unset($this->context->cookie->f_reserved_quantity);
            unset($this->context->cookie->f_mvt_physical);
            unset($this->context->cookie->f_mvt_reserved);
            unset($this->context->cookie->f_sign);
            unset($this->context->cookie->f_employee);
            unset($this->context->cookie->f_reason_presta);
            unset($this->context->cookie->f_comments);
            unset($this->context->cookie->f_date_ini);
            unset($this->context->cookie->f_date_fin);
            $this->context->cookie->filter = false;
        }
        if (!$this->context->cookie->f_product_name) {
            $f_product_name = '';
        } else {
            $f_product_name = $this->context->cookie->f_product_name;
        }
        if (!$this->context->cookie->f_reference) {
            $f_reference = '';
        } else {
            $f_reference = $this->context->cookie->f_reference;
        }
         if (!$this->context->cookie->f_manufacturer) {
            $f_manufacturer = '';
        } else {
            $f_manufacturer = $this->context->cookie->f_manufacturer;
        }
        if (!$this->context->cookie->f_order) {
            $f_order = '';
        } else {
            $f_order = $this->context->cookie->f_order;
        }
        if (!$this->context->cookie->f_order_status_name) {
            $f_order_status_name = '';
        } else {
            $f_order_status_name = $this->context->cookie->f_order_status_name;
        }
        if (!$this->context->cookie->f_stock_quantity) {
            $f_stock_quantity = '';
        } else {
            $f_stock_quantity = $this->context->cookie->f_stock_quantity;
        }

        if(Tools::getValue('movimientosFilter_stock_quantity')=='0')
             $f_stock_quantity =0;
        

        if (!$this->context->cookie->f_physical_quantity) {
            $f_physical_quantity = '';
        } else {
            $f_physical_quantity = $this->context->cookie->f_physical_quantity;
        }

       if(Tools::getValue('movimientosFilter_physical_quantity')=='0')
             $f_physical_quantity =0;
        
        if (!$this->context->cookie->f_reserved_quantity) {
            $f_reserved_quantity = '';
        } else {
            $f_reserved_quantity = $this->context->cookie->f_reserved_quantity;
        }

        
       if(Tools::getValue('movimientosFilter_reserved_quantity')=='0')
             $f_reserved_quantity =0;
        

        if (!$this->context->cookie->f_mvt_physical) {
            $f_mvt_physical = '';
        } else {
            $f_mvt_physical = $this->context->cookie->f_mvt_physical;
        }

        if(Tools::getValue('movimientosFilter_mvt_physical')=='0')
             $f_mvt_physical =0;
      

        if (!$this->context->cookie->f_mvt_reserved) {
            $f_mvt_reserved = '';
        } else {
            $f_mvt_reserved = $this->context->cookie->f_mvt_reserved;
        }

        if(Tools::getValue('movimientosFilter_mvt_reserved')=='0')
             $f_mvt_reserved =0;

      

        if (!$this->context->cookie->f_sign) {
            $f_sign = '';
        } else {
            $f_sign = $this->context->cookie->f_sign;
        }
        if (!$this->context->cookie->f_employee) {
            $f_employee = '';
        } else {
            $f_employee = $this->context->cookie->f_employee;
        }
        if (!$this->context->cookie->f_reason_presta) {
            $f_reason_presta = '';
        } else {
            $f_reason_presta = $this->context->cookie->f_reason_presta;
        }
        if (!$this->context->cookie->f_comments) {
            $f_comments = '';
        } else {
            $f_comments = $this->context->cookie->f_comments;
        }
        if (!$this->context->cookie->f_date_ini) {
            $f_date_ini = '';
        } else {
            $f_date_ini = $this->context->cookie->f_date_ini;
        }
        if (!$this->context->cookie->f_date_fin) {
            $f_date_fin = '';
        } else {
            $f_date_fin = $this->context->cookie->f_date_fin;
        }
        if (Tools::isSubmit('sortMovimientos')) {
            $this->context->cookie->order_way = Tools::getValue('order_way');
            $this->context->cookie->attribute = Tools::getValue('attribute');
        }
        if (Tools::isSubmit('ver')) {
          /*  $id       = Tools::getValue('factura');
            $invoice  = new OrderInvoice($id); // get invoice
            $order    = $invoice->getOrder(); // get order
            $customer = new Address($order->id_address_invoice);
            $currency = new Currency($order->id_currency); // get currency
            return $this->details($invoice, $order, $customer, $currency);*/
        }
        $order_way = Tools::getValue('order_way');
        $attribute = Tools::getValue('attribute');
        if (isset($this->context->cookie->order_way)) {
            $order_way = $this->context->cookie->order_way;
        } else {
            $order_way = '';
        }
        if (isset($this->context->cookie->attribute)) {
            $attribute = $this->context->cookie->attribute;
        } else {
            $attribute = 'a.`id_stock_available`';
        }


         if ($reset) {
            $f_stock_quantity='';
            $f_reserved_quantity ='';
            $f_physical_quantity ='';
            $f_mvt_physical ='';
            $f_mvt_reserved ='';
        }

       

        $p = array();
        array_push($p, $f_product_name);
        array_push($p, $f_reference);
        array_push($p, $f_manufacturer);
        array_push($p, $f_order);
        array_push($p, $f_order_status_name);
        array_push($p, $f_stock_quantity);
        array_push($p, $f_physical_quantity);
        array_push($p, $f_reserved_quantity);
        array_push($p, $f_mvt_physical);
        array_push($p, $f_mvt_reserved);
        array_push($p, $f_sign);
        array_push($p, $f_employee);
        array_push($p, $f_reason_presta);
        array_push($p, $f_comments);
        array_push($p, $f_date_ini);
        array_push($p, $f_date_fin);
        array_push($p, $attribute);



        $res           = $this->searchMovimientosBy($p, $movimientoInicial, $mostradosPorPagina, $order_way);
        $movimientos      = $res[0];
        $sNumero       = true;
        $cunt          = $this->searchMovimientosBy($p, $movimientoInicial, $mostradosPorPagina, $order_way, $sNumero,true);
        $cont_movimientos = $cunt[1];
        /************************/
        if (isset($this->context->cookie->f_product_name)
            || isset($this->context->cookie->f_reference)
            || isset($this->context->cookie->f_manufacturer)
            || isset($this->context->cookie->f_order)
            || isset($this->context->cookie->f_order_status_name)
            || isset($this->context->cookie->f_stock_quantity)
            || isset($this->context->cookie->f_physical_quantity)
            || isset($this->context->cookie->f_reserved_quantity)
            || isset($this->context->cookie->f_mvt_physical)
            || isset($this->context->cookie->f_mvt_reserved)
            || isset($this->context->cookie->f_sign)
            || isset($this->context->cookie->f_employee)
            || isset($this->context->cookie->f_reason_presta)
            || isset($this->context->cookie->f_comments)
            || isset($this->context->cookie->f_date_ini)
            || isset($this->context->cookie->f_date_fin)) {
            $this->context->cookie->filter = true;
        }
        /************************/
        $path           = 'index.php?controller=GestAvdStock&token=';
        $sortMovimientos   = $path . Tools::getAdminTokenLite('GestAvdStock') . '&sortMovimientos';
        $admin_token    = Tools::getAdminTokenLite('AdminOrders');
        $module_token   = Tools::getAdminTokenLite('AdminModules');
        $updateMovimientos = $path . Tools::getAdminTokenLite('GestAvdStock') . '&updateMovimientos';
        $searchMovimientos = $path . Tools::getAdminTokenLite('GestAvdStock') . '&searchMovimientos';
        $uploadCSV = $path . Tools::getAdminTokenLite('GestAvdStock') . '&uploadCSV';
        $changeQuantity = $path . Tools::getAdminTokenLite('GestAvdStock') . '&changeQuantity';  
        $paginacion     = $path . Tools::getAdminTokenLite('GestAvdStock') . '&npag';
        $paginacion2    = $path . Tools::getAdminTokenLite('GestAvdStock') . '&npag2';
        $ver            = $path . Tools::getAdminTokenLite('GestAvdStock') . '&ver';
        $urlVPedido     = $this->context->link->getAdminLink('AdminOrders') . '&vieworder&id_order=';
        //https://test.todocampers.com/staff/index.php/sell/catalog/products/4?_token=AeXXxxIMblnvakjBiRo9STAWP04z0X3HHM4F_acj1jo1607
        //$urlVProduct     =  $this->context->link->getAdminLink('AdminProducts') . '&updateproduct&id_product=';

        $urlVProduct  = 'index.php?controller=AdminProducts';
        $urlVProduct .='&token='.Tools::getAdminTokenLite('AdminProducts');
        $urlVProduct .='&id_product=';
        

        $urlMovimientos =$this->context->link->getAdminLink('GestAvdStockMvt') .'&searchMovimientos&submitState=9&movimientosFilter_reference=';
        $urlDFactura    = $this->context->link->getAdminLink('AdminPdf') . '&submitAction=generateInvoicePDF&id_order=';
        if (empty($_SERVER['HTTPS'])) {
            $protocolo = 'http://';
        } else {
            $protocolo = 'https://';
        }
        $urltienda = $protocolo . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . "modules/gestavdstock/";
        $urlEditComment=$urltienda."editCommentStock.php";
        $urlEditQuantity=$urltienda."editQuantityStock.php";
        $urlEditStockDB=$urltienda."editValores.php";
        $urllogs=$urltienda."/logs/todocampers.log";
        $urllogsclean=$urltienda."cleanlog.php";
        /************************/
        $paginasTotales = ceil($cont_movimientos / $mostradosPorPagina);
        $this->context->smarty->assign(array(
            'mensaje'            => $mensaje,
            'id_employee'        => Context::getContext()->employee->id,
            'uploadCSV'          => $uploadCSV,
            'changeQuantity'          => $changeQuantity,
            'info'               => $info,
            'admin_token'        => $admin_token,
            'module_token'       => $module_token,
            'updateMovimientos'     => $updateMovimientos,
            'sortMovimientos'       => $sortMovimientos,
            'f_product_name'           => $f_product_name,
            'f_reference'          => $f_reference,
            'f_manufacturer'          => $f_manufacturer,
            'f_order'    => $f_order,
            'f_order_status_name' => $f_order_status_name,
            'f_stock_quantity'              => $f_stock_quantity,
            'f_physical_quantity'          => $f_physical_quantity,
            'f_reserved_quantity'          => $f_reserved_quantity,
            'f_mvt_physical'   => $f_mvt_physical,
            'f_sign'      => $f_sign,
            'f_employee'      => $f_employee,
            'f_reason_presta'      => $f_reason_presta,
            'f_comments'      => $f_comments,
            'f_date_ini'         => $f_date_ini,
            'f_date_fin'         => $f_date_fin,
            'f_mvt_reserved'  => $f_mvt_reserved,
            'filter'             => $this->context->cookie->filter,
            'cont_movimientos'      => $cont_movimientos,
            'movimientos'           => $movimientos,
            'searchMovimientos'     => $searchMovimientos,
            'paginacion'         => $paginacion,
            'paginacion2'        => $paginacion2,
            'paginasTotales'     => $paginasTotales,
            'paginaActual'       => $paginaActual,
            'mostradosPorPagina' => $mostradosPorPagina,
            'ver'                => $ver,
            'urlVerPedido'       => $urlVPedido,
            'urlVProduct'       => $urlVProduct,
            'urlDescargaFactura' => $urlDFactura,
            'urlEditComment' => $urlEditComment,
            'urlEditStockDB' => $urlEditStockDB,
            'urltienda'          => $urltienda,
            'urlMovimientos'          => $urlMovimientos,
            'urlEditQuantity'=>$urlEditQuantity,
            'urllogs'=>$urllogs,
            'urllogsclean'=>$urllogsclean,
        ));
        $this->setTemplate('../../../../modules/gestavdstock/views/templates/admin/admin.tpl');
    }
    public function searchMovimientosBy($p, $inVIn = null, $limit = null, $order = null, $sacarNumero = false,$cort = false)
    {
        

        $f_product_name           = $p[0];
        $f_reference          = $p[1];
        $f_manufacturer          = $p[2];
        $f_order    = $p[3];
        $f_order_status_name = $p[4];
        $f_stock_quantity              = $p[5];
        $f_physical_quantity          = $p[6];
        $f_reserved_quantity          = $p[7];
        $f_mvt_physical   = $p[8];
        $f_mvt_reserved  = $p[9];
        $f_sign      = $p[10];
        $f_employee      = $p[11];
        $f_reason_presta      = $p[12];
        $f_comments      = $p[13];
        $date_ini           = $p[14];
        $date_fin           = $p[15];
        $attribute          = $p[16];

        //lang
        $id_lang=$this->context->language->id;

        if ($limit == null) {
            $limit = 1000;
        }

        $sql= 'SELECT DISTINCT a.* from ' . _DB_PREFIX_ . 'stock_adClearis a '; 
        $sql.='WHERE 1 ';
        $sql.='AND a.`id_lang` ='.$id_lang.' ';
        $sql.='AND a.reference NOT LIKE "%' . pSQL("Pack") . '%" ';
       // $sql.='AND a.refCompleta !="" ';


       /* $sql = 'SELECT  a.* , pl.name as product_name,p.reference as reference, m.name as manufacturer ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'stock_available a ';
        $sql .= 'JOIN ' . _DB_PREFIX_ . 'product_lang pl ON (pl.id_product = a.id_product and pl.id_lang='.$id_lang.') ';
        $sql .= 'JOIN ' . _DB_PREFIX_ . 'product p ON (p.id_product = a.id_product) ';
        //$sql .= 'JOIN ' . _DB_PREFIX_ . 'order o ON (o.id_order = a.id_order) '
        $sql .= 'JOIN ' . _DB_PREFIX_ . 'manufacturer m ON (m.id_manufacturer = p.id_manufacturer) ';
        $sql .= 'WHERE 1 ';*/

        //$sql = $sql . 'AND a.id_product=782 ';
       
        //$f_reference = preg_replace('([^0-9])', '', $f_reference);
        if ($f_product_name != '') {
            $sql = $sql . 'AND a.`nombreCompleto`  LIKE "%' .  pSQL ($f_product_name) . '%" ';
            $sql.=' COLLATE utf8mb4_general_ci ';
        }
        if ($f_reference != '') {
           // $sql = $sql . 'AND (a.`reference` LIKE "%' . pSQL($f_reference) . '%" or a.`refCompleta` LIKE "%' . pSQL($f_reference) . '%" ';
            $sql = $sql . 'AND (a.`reference` LIKE "%' . pSQL($f_reference) . '%" ';
            $sql.=' COLLATE utf8mb4_general_ci) ';
        }
         if ($f_manufacturer != '') {
            $sql = $sql . 'AND (a.`manufacturer` LIKE "%' . pSQL($f_manufacturer) . '%" ';
            $sql.=' COLLATE utf8mb4_general_ci) ';
        }
        if ($f_order != '') {
            $sql = $sql . 'AND a.`order`=' . (int) $f_order .  ' ';
        }
        
        if (($f_stock_quantity != '') || ($f_stock_quantity=="0")){
            $sql = $sql . 'AND a.`quantity`=' . (int) ($f_stock_quantity) .  ' ';
        }

        if (($f_physical_quantity != '') || ($f_physical_quantity=="0")) {
            $sql = $sql . 'AND a.`physical_quantity`=' . (int) ($f_physical_quantity) .  ' ';
        }

        if (($f_reserved_quantity != '') || ($f_reserved_quantity=="0")){
            $sql = $sql . 'AND a.`reserved_quantity`=' . (int) ($f_reserved_quantity) .  ' ';
        }
        
        if ($f_reason_presta != '') {
            $sql = $sql . 'AND (a.`reason_presta` LIKE "%' . pSQL($f_reason_presta) . '%" ';
            $sql.=' COLLATE utf8mb4_general_ci) ';
        }

         if ($f_comments != '') {
            $sql = $sql . 'AND (a.`comments` LIKE "%' . pSQL($f_comments) . '%" ';
            $sql.=' COLLATE utf8mb4_general_ci) ';
        }

       
        if ($date_ini != '' || $date_fin != '') {
            $sql = $sql . 'AND a.`date_add` BETWEEN "' . pSQL($date_ini) . '" AND "' . pSQL($date_fin) . '" ';
        }

        

        $sql = $sql . ' ORDER BY ' . $attribute . ' ' . ((string) $order ? $order : 'DESC ');
        if (!$sacarNumero) {
            $sql = $sql . ' LIMIT ' . (int) $inVIn . ', ' . (int) $limit;
        }

        // echo $sql;
        

        $movimientos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

        //añadir atributo

        $id_lang = (int) Configuration::get('PS_LANG_DEFAULT');

        
        if(!$cort){
        
        $mov=array();
        if (is_array($movimientos) || is_object($movimientos))
{
        foreach($movimientos as &$movimiento)
        {
            $image = Image::getCover($movimiento['id_product']);
            $image2;

            if($movimiento['id_product_attribute']>0)
            {
                //Obtener Referencia
              /*  $product_name=$movimiento['product_name'];
                $reference=StockAvailable::getReferenceAtributo($movimiento['id_product'],$movimiento['id_product_attribute']);
                $name=StockAvailable::getNameAtributo($movimiento['id_product_attribute']);
                if($name)
                $product_name=$product_name. " - ". $name;

                if($reference!="")
                    $movimiento['reference']=$reference;

                $movimiento['product_name']=$product_name;*/

               $image2=Image::getBestImageAttribute(1,$id_lang,$movimiento['id_product'],$movimiento['id_product_attribute']);
            }
          
        
            if(!$image['id_image'])
                $image=$image2;

            
 
            // Load Product Object
            $product = new Product($movimiento['id_product']);
 
            // Initialize the link object
                $link = new Link;


 
            $imagePath = $link->getImageLink($product->link_rewrite[Context::getContext()->language->id], $image['id_image'], 'large_default');
 
           // echo $imagePath;
            $movimiento['image']="https://".$imagePath;

           
          
        }
    }
    }
   

        

       return array($movimientos, count($movimientos));
        }
    

   

    public function getReferenceAtributo($id_product,$id_product_attribute)
    {
        $sql = 'SELECT  p.reference ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'product_attribute p ';
        $sql .= 'WHERE p.id_product_attribute=' . $id_product_attribute . ' and p.id_product=' . $id_product .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['reference'];
        }
        else
            return "";

    }

    public function getNameAtributo($id_product_attribute)
    {
        //lang
        $id_lang=$this->context->language->id;
        $sql = 'SELECT  name ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'attribute_lang a ';
        $sql .= 'WHERE a.id_attribute=' . $id_product_attribute . ' and a.id_lang=' . $id_lang .' ';
        if($row = Db::getInstance()->getRow($sql))
        {
            return $row['name'];
        }
        else
            return "";

    }

public function importarCSV()
{
     $this->setTemplate('../../../../modules/gestavdstock/views/templates/admin/import.tpl');
}

public function cambiarStock($boxes)
{
     //Cambios Clearis 24 Marzo

     $comment            = Tools::getValue('commentG');
    $quantity            = Tools::getValue('quantityG');
    $id_employee            = Tools::getValue('id_employeeG');

     foreach ($boxes as $id_stock) {
            $stock=new StockAvailable($id_stock);

            
            //Buscar reference que hace falta

        $sql = 'SELECT reference ';
        $sql .= 'FROM ' . _DB_PREFIX_ . 'stock_adClearis ';
        $sql .= 'WHERE id_stock_available="' . $id_stock.'"';



        if($row = Db::getInstance()->getRow($sql))
        {
            $reference=$row['reference'];
            StockAvailable::insertInventario($reference,$quantity,$comment,$id_stock);
        }
        else
        {
            $info     = $this->l('Update stock Error in id_stock: '.$id_stock);
        $correcto = false;
        return array($info, $correcto);
        }
       

        }

     $info     = $this->l('Update stock ok');
        return array(false,$info);

/*
    $comment            = Tools::getValue('commentG');
    $quantity            = Tools::getValue('quantityG');
    $id_employee            = Tools::getValue('id_employeeG');

     foreach ($boxes as $id_stock) {
            $stock=new StockAvailable($id_stock);

    StockAvailable::setQuantityModule($stock->id_product,$stock->id_product_attribute,$quantity,$id_employee,$comment);


$sql="UPDATE " . _DB_PREFIX_ . "stock_available set comments='".$comment."',physical_quantity='".$quantity."' where id_stock_available=".$id_stock;
    if(!Db::getInstance()->execute($sql))
    {
        $info     = $this->l('Update stock Error in product: '.$stock->id_product);
        $info    .= $this->l(' and id_attribute: '.$stock->id_product_attribute);
        $correcto = false;
        return array($info, $correcto);
    }

}
        $info     = $this->l('Update stock ok');
        return array(false,$info);*/
       
}


 public function createCSV($boxes, $tipo, $mail = false)
    {
        $delimiter = ";";
        set_time_limit(0);
        if ($tipo == "CSV") {
            $fileName = 'stock_' . date("d_m_Y_H_i_s") . '.csv';
            $excel    = false;
        } else {
            $fileName  = 'stock_' . date("d_m_Y_H_i_s") . '.xls';
            $excel     = true;
            $delimiter = ';';
        }
        if (!$mail) {
            if ($tipo == "CSV") {
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header('Content-Description: File Transfer');
                header("Content-type: text/csv; charset=UTF-8'");
            } else {
                header('Content-type: application/vnd.ms-excel');
            }
            header("Content-Disposition: attachment; fileName={$fileName}");
            header("Expires: 0");
            if ($tipo == "CSV") {
                header("Pragma: public");
            } else {
                header("Pragma: no-cache");
            }
            echo "\xEF\xBB\xBF";
            $f = fopen(
                'php://output',
                'w'
            );
        } else {
            $f = fopen(_PS_MODULE_DIR_ . 'gestavdstock/tmp/' . $fileName, "w+");
        }
        $titles = $this->generateCabeceraLinea();
        fputcsv(
            $f,
            $titles,
            $delimiter,
            '"'
        );
        foreach ($boxes as $id_stock) {
            $linea = $this->generateLinea($id_stock);
            fputcsv(
                $f,
                $linea,
                $delimiter,
                '"'
            );
        }
        fclose($f);
        if (!$mail) {
            die();
        } else {
            return $fileName;
        }
    }


 public function generateCabeceraLinea()
    {
        $titles = array("NOMBRE PRODUCTO", "REFERENCIA", "FABRICANTE", "CANTIDAD STOCK", "CANTIDAD FÍSICA", "CANTIDAD RESERVADA", "COMENTARIOS");
        return $titles;
    }


 public function generateLinea($id_stock,$excel = false)
    {
         $id_lang = (int) Configuration::get('PS_LANG_DEFAULT');
        
         $sql= 'Select a.* from ' . _DB_PREFIX_ . 'stock_adClearis a '; 
        $sql.='WHERE 1 ';
        $sql.='AND a.`id_lang` ='.$id_lang.' ';
        $sql.='AND a.reference NOT LIKE "%' . pSQL("Pack") . '%" ';
        $sql.='AND a.id_stock_available ="'.$id_stock.'"';

         $movimientos = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

         $linea                    = array();
         $linea['NOMBRE PRODUCTO']=$movimientos[0]['nombreCompleto'];
         $linea['REFERENCIA']=$movimientos[0]['reference'];
         $linea['FABRICANTE']=$movimientos[0]['manufacturer'];
         $linea['CANTIDAD STOCK']=$movimientos[0]['quantity'];
         $linea['CANTIDAD FÍSICA']=$movimientos[0]['physical_quantity'];
         $linea['CANTIDAD RESERVADA']=$movimientos[0]['reserved_quantity'];
         $linea['COMENTARIOS']=$movimientos[0]['comments'];

        return $linea;
    }


public function getLogo()
    {
        $logo    = '';
        $context = Context::getContext();
        $id_shop = (int) $context->shop->id;

        $logo = _PS_IMG_DIR_ . Configuration::get('PS_LOGO', null, null, $id_shop);

        return $logo;
    }



    //  public function initPageHeaderToolbar()
    // {
    //     if ($this->module->active) {
    //         if (!Shop::isFeatureActive() || Shop::getContext() == Shop::CONTEXT_SHOP) {
    //             $this->page_header_toolbar_btn['configure'] = array(
    //                 'href' => $this->context->link->getAdminLink('AdminModules') . '&configure=gestavdstock',
    //                 'desc' => $this->l('Configure'),
    //                 'icon' => 'process-icon-configure',
    //             );
    //         }
    //     }
    //     parent::initPageHeaderToolbar();
    //     $this->context->smarty->clearAssign('help_link');
    // }

}

    
